SKIPUNZIP=0
check_magisk_version() {
	ui_print "- Magisk version: $MAGISK_VER_CODE"
	ui_print "- Module version: $(grep_prop version "${TMPDIR}/module.prop")"
	if [ "$MAGISK_VER_CODE" -lt 20400 ]; then
		ui_print "***************************************************"
		ui_print "! 请安装 Magisk v20.4+ (20400+)"
		abort    "***************************************************"
	fi
}
find_trip_point_temp_files() {
	ui_print "***************************************************"
	ui_print "- Trip point temp files:"
	for THERMAL_ZONE in $(ls /sys/class/thermal/thermal_zone*/type); do
		if cat $THERMAL_ZONE | grep -E "cpu|gpu|ddr" >/dev/null; then
			for TRIP_POINT_TEMP in $(ls ${THERMAL_ZONE%/*}/trip_point_*_temp); do
				if [ "$(cat $TRIP_POINT_TEMP)" -lt "110000" ]; then
					ui_print "$TRIP_POINT_TEMP $(cat ${TRIP_POINT_TEMP%/*}/type)"
				fi
			done
		fi
	done
}
remove_sysperfconfig() {
	ui_print "***************************************************"
	for SYSPERFCONFIG in $(ls /system/vendor/etc/perf/perf*.xml /system/vendor/etc/perf/power*.xml  /system/vendor/etc/zperf_*); do
		[[ ! -d $MODPATH${SYSPERFCONFIG%/*} ]] && mkdir -p $MODPATH${SYSPERFCONFIG%/*}
		ui_print "- Config file:$SYSPERFCONFIG"
		touch $MODPATH$SYSPERFCONFIG
	done
	ui_print "***************************************************"
}
check_magisk_version
find_trip_point_temp_files
remove_sysperfconfig
set_perm_recursive "$MODPATH" 0 0 0755 0644
ui_print "***************************************************"
ui_print "- 部分功能可在模块的 system.prop 文件中开启或关闭！"
ui_print "***************************************************"
chmod a+x ${MODPATH}/*.sh
