#!/system/bin/sh
#
# Copyright (C) 2021-2022 Matt Yang
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

###############################
# Platform info functions
###############################

# $1:"4.14" return:string_in_version

# $1:board_name
get_config_name() {
    case "$1" in 
    "taro") echo "$(_get_taro_type)" ;;
    "lahaina") echo "$(_get_lahaina_type)" ;;
    "shima") echo "$(_get_lahaina_type)" ;;
    "yupik") echo "$(_get_lahaina_type)" ;;
    "kona") echo "$(_get_kona_type)" ;;  
    "pineapple") echo "sdm8g3" ;;
    "kalama") echo "sdm8g2" ;;
    "sm8475") echo "sdm8g1+" ;; 
    "sm8450") echo "sdm8g1" ;;
    "sm7475") echo "sdm7g2+" ;;
    "garnet") echo "sdm7sgen2" ;;
    "taro") echo "sdm7g2+" ;;   
    "msmnile") echo "sdm855" ;; # 855, 860
    "sdm845") echo "sdm845" ;;
    
    "lahaina") echo "sdm888" ;;
    "am8350") echo "sdm888" ;;
    "mt6885") echo "mtd1000" ;;
    "mt6891") echo "mtd1100" ;;
    "mt6893") echo "mtd1200" ;;
    "mt6895") echo "mtd8100" ;;
    "mt6895") echo "mtd8200" ;;
    "mt6897") echo "mtd8300Ultra" ;;
    "mt6983") echo "mtd9000" ;;
    *) echo "unsupported" ;;
    esac
}
