#!/bin/bash

# 优化fsync调用的频率，减少写入延迟
echo 1000 > /proc/sys/vm/dirty_writeback_centisecs

# 增加TCP窗口大小
echo 524288 > /proc/sys/net/core/wmem_default
echo 524288 > /proc/sys/net/core/wmem_max
echo 524288 > /proc/sys/net/core/rmem_default
echo 524288 > /proc/sys/net/core/rmem_max

# 增加 TCP 重传超时时间：这可以减少因网络延迟导致的不必要的重传。
echo 200 > /proc/sys/net/ipv4/tcp_retries2

# 增加 TCP 拥塞窗口：这可以提高网络吞吐量。
echo 1 > /proc/sys/net/ipv4/tcp_window_scaling

# 启用 TCP 时间戳：这可以减少 RTT 的计算误差。
echo 1 > /proc/sys/net/ipv4/tcp_timestamps

# 减少 SYN 重传次数：这可以加快连接的建立。
echo 5 > /proc/sys/net/ipv4/tcp_syn_retries

# 增加 SYN 重传超时时间：这可以减少因网络延迟导致的连接失败。
echo 1 > /proc/sys/net/ipv4/tcp_synack_retries

# 增加 TCP 缓冲区内存：这可以提高网络吞吐量。
echo 16777216 > /proc/sys/net/core/netdev_max_backlog

# 启用 SO_REUSEADDR：这可以避免 TIME_WAIT 状态的连接占用端口。
echo 1 > /proc/sys/net/ipv4/tcp_tw_reuse

# 调整 TCP 快速恢复算法：这可以在网络拥塞时快速恢复。
echo 3 > /proc/sys/net/ipv4/tcp_fastopen

# 调整路由表缓存：这可以减少路由查找的时间。
echo 128 > /proc/sys/net/ipv4/route/max_size

# 调整路由表缓存的增长因子：这可以动态调整路由表的大小。
echo 0 > /proc/sys/net/ipv4/route/gc_timeout

# 减少TCP拥塞控制的启动时间
echo 3 > /proc/sys/net/ipv4/tcp_slow_start_after_idle

# 开启TCP时间戳
echo 1 > /proc/sys/net/ipv4/tcp_timestamps

# 开启TCP窗口缩放
echo 1 > /proc/sys/net/ipv4/tcp_window_scaling

# 开启TCP重用
echo 1 > /proc/sys/net/ipv4/tcp_tw_reuse

# 优化系统性能和内存管理
sysctl -w vm.swappiness=10
sysctl -w vm.vfs_cache_pressure=50
sysctl -w vm.dirty_ratio=20
sysctl -w vm.dirty_background_ratio=5