#!/system/bin/sh
#
# Copyright (C) 2021-2022 Matt Yang
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

BASEDIR="$(dirname $(readlink -f "$0"))"
. $BASEDIR/pathinfo.sh
. $BASEDIR/libsysinfo.sh

# $1:error_message
abort() {
    echo "$1"
    echo "! Uperf installation failed."
    exit 1
}

# $1:file_node $2:owner $3:group $4:permission $5:secontext
set_perm() {
    chown $2:$3 $1
    chmod $4 $1
    chcon $5 $1
}

# $1:directory $2:owner $3:group $4:dir_permission $5:file_permission $6:secontext
set_perm_recursive() {
    find $1 -type d 2>/dev/null | while read dir; do
        set_perm $dir $2 $3 $4 $6
    done
    find $1 -type f -o -type l 2>/dev/null | while read file; do
        set_perm $file $2 $3 $5 $6
    done
}


install_uperf() {
    echo "- Finding platform specified config"
    echo "- ro.board.platform=$(getprop ro.board.platform)"
    echo "- ro.product.board=$(getprop ro.product.board)"

    local target
    local cfgname
    target="$(getprop ro.board.platform)"
    cfgname="$(get_config_name $target)"
    if [ "$cfgname" == "unsupported" ]; then
        target="$(getprop ro.product.board)"
        cfgname="$(get_config_name $target)"
    fi

    if [ "$cfgname" == "unsupported" ] || [ ! -f $MODULE_PATH/config/$cfgname.json ]; then
        abort "! Target [$target] not supported."
    fi

    echo "- Uperf config is located at $USER_PATH"
    mkdir -p $USER_PATH
    mv -f $USER_PATH/uperf.json $USER_PATH/uperf.json.bak
    cp -f $MODULE_PATH/config/$cfgname.json $USER_PATH/uperf.json
    [ ! -e "$USER_PATH/perapp_powermode.txt" ] && cp $MODULE_PATH/config/perapp_powermode.txt $USER_PATH/perapp_powermode.txt
    rm -rf $MODULE_PATH/config
    set_perm_recursive $BIN_PATH 0 0 0755 0755 u:object_r:system_file:s0
}
echo ""
echo  "                  《新版发布万岁》（果冻版）                          "
sleep 0.9
echo "*本uperf从1.8起，已是一个完整的模块，可以放弃scene和yc管理器的使用，自动切换模式，内置dfps "
sleep 0.9
echo "* Uperf https://github.com/yc9559/uperf/"
sleep 0.9
echo "* Uperf原作者: Matt Yang "
echo "* Uperf二改作者:  @鲁迅的霸权 即现在的@不知道叫啥爱 "
echo "* - - - - - - - - - - - + + - + + + - - - - - "
echo "* uperf三改 ：掌柜 汍滥/岁眸            l"
sleep 0.9
echo "* 出事来找我  感谢                          l
如果刷入失败，可能是没有适配
后面暂时不在适配
有兴趣的话可以加一下qq群 
102190390
哎嘿嘿
1111111111111111111111
11111111111111111111
1111111"
echo""
echo "* 重启后请务必查看日志是否生效"
echo "对了对了，为了让你更省时间"
sleep 1
echo "/storage/emulated/0/Android/yc/uperf/
这个是路径(・ω< )★～ciallo
祝大家 国庆快乐 
心想人生 万事如意 
哐哐发大财
哐哐有财运
臭美的更美 耍帅的更帅
"
   
sleep 4
echo""
echo " 
      (・ω< )★～ciallo       (・ω< )★～ciallo
      (・ω< )★～ciallo        (・ω< )★～ciallo
      (・ω< )★～ciallo        (・ω< )★～ciallo
      

       游戏我自己感觉应该会炸- - - - - - - - - - -
      - - - - - - - - - - - 因为我没多少游戏需求
      
      (・ω< )★～ciallo        (・ω< )★～ciallo
      (・ω< )★～ciallo        (・ω< )★～ciallo
      (・ω< )★～ciallo        (・ω< )★～ciallo
      (・ω< )★～ciallo        (・ω< )★～ciallo"

sleep 4

echo "               《父辈爱情freestyle》"
sleep 0.9
echo ""

echo "★～                从前用一支笔   (・ω< )★～ciallo"
sleep 0.9
echo "(★～                 写一封信 (・ω<)★～ciallo"
sleep 0.9
echo "★～                放在一辆马车"
sleep 0.9
echo "         相爱的两个人守一辈子不是一种假说愉"
sleep 0.9
echo "             王宝钏等薛平贵了整整一十八年"
sleep 0.9
echo "           而现在转瞬即逝的爱被别人当作洒脱斗"
sleep 0.9
echo "            出事的话是我们的责任 莫要去找大佬"
sleep 4
echo "            如果刚开始刷术后功耗比较高的话 
                     请等待一会  多用一段时间                                         如果还不行的话  来告诉我 有时间的话就来改一下"
sleep 2
echo "这可能是现在最后一首改版咯(・ω< )★～ciallo"
sleep 0.9
echo "在学校要好好学习哟(・ω< )★～ciallo"
sleep 0.9
echo "(・ω< )★～ciallo不然你就是南粮"
sleep 0.1
echo "                 《更新内容》      "
sleep 0.9
echo""
echo "(・ω< )★～ciallo               "
echo "(・ω< )★～ciallo    增加TCP窗口大小 《可能》
      (・ω< )★～ciallo    开启TCP时间戳   《可能》
      (・ω< )★～ciallo    开启TCP重用    《可能》
      (・ω< )★～ciallo   开启TCP窗口缩放 《可能》
      (・ω< )★～ciallo  增加 TCP 重传超时时间《可能》
      (・ω< )★～ciallo  增加 TCP 拥塞窗口《可能》
      (・ω< )★～ciallo  减少 SYN 重传次数《可能》
      (・ω< )★～ciallo  增加 TCP 缓冲区内存《可能》
      (・ω< )★～ciallo  启用 SO_REUSEADDR 《可能》
      (・ω< )★～ciallo  整 TCP 快速恢复算法《可能》
      (・ω< )★～ciallo  调整路由表缓存  《可能》
      (・ω< )★～ciallo 调整路由表缓存的增长因子《可能》
      (・ω< )★～ciallo      优化内存管理《可能》 
      (・ω< )★～ciallo      优化功耗模块     
      (・ω< )★～ciallo         甜蜜值
      (・ω< )★～ciallo         最大值
      (・ω< )★～ciallo        典型功率
      (・ω< )★～ciallo        典型频率
      (・ω< )★～ciallo        最低频率
      (・ω< )★～ciallo    优化优先级亲和性   
      (・ω< )★～ciallo   优化fsync调用的频率《可能》
      (・ω< )★～ciallo        线程优化  《可能》"     
echo"
      (・ω< )★～ciallo 减少TCP拥塞控制的启动时间  "
sleep 1
echo " 
      (・ω< )★～ciallo       (・ω< )★～ciallo
      (・ω< )★～ciallo        (・ω< )★～ciallo
      (・ω< )★～ciallo        (・ω< )★～ciallo
      (・ω< )★～ciallo        (・ω< )★～ciallo
      (・ω< )★～ciallo        (・ω< )★～ciallo
      (・ω< )★～ciallo        (・ω< )★～ciallo
      (・ω< )★～ciallo        (・ω< )★～ciallo"
sleep 4
echo "* ...........- - - - - - - - - - - - - - - - - - - - "
install_uperf
echo "* Done"
echo "* 重启后请务必查看日志是否生效"
echo "对了对了，为了让你更省时间"
sleep 1
echo "/storage/emulated/0/Android/yc/uperf/
这个是路径(・ω< )★～ciallo"
sleep 2

