#!/bin/sh

function check_dir() {
    if [ ! -d "$1" ]; then
        mkdir -p "$1"
    fi
}

function set_permissions() {
    chmod -R 777 "$1"
}

function copy_and_remove() {
    src="$1"
    dest="$2"
    cp -f "$src" "$dest"
    if [ $? -eq 0 ]; then
        rm -f "$src"
    fi
}

function is_downloading() {
    local file="$1"
    local size1=$(stat -c %s "$file")
    sleep 0.2
    local size2=$(stat -c %s "$file")

    if [ "$size1" -ne "$size2" ]; then
        return 0
    else
        return 1
    fi
}

# 移动文件并分类
function move_files() {
    for file in "$1"/*; do
        if [ -f "$file" ]; then
            # 检查文件是否正在下载
            case "$file" in
                *.part|*.crdownload|*.tmp|*.download)
                    continue
                    ;;
            esac

            if is_downloading "$file"; then
                continue
            fi

            size=$(stat -c%s "$file")
            if [ "$size" -eq 0 ]; then
                continue
            fi

            case "$file" in
                *.Gz|*.gz|*.ZIP|*.7z|*.zip|*.rar|*.tar.gz|*.tgz|*.tar.bz2|*.tar.xz|*.iso|*.dmg|*.cab|*.pkg|*.deb|*.xz|*.cpio)
                    dest="/storage/emulated/0/下载/压缩包"
                    ;;
                *.png|*.jpg|*.jpeg|*.tiff|*.gif|*.bmp|*.webp|*.psd|*.eps|*.raw|*.hdr|*.ai|*.cdr|*.indd|*.pcx|*.tga|*.ico|*.svg)
                    dest="/storage/emulated/0/下载/图片"
                    ;;
                *.apk|*.APK|*.exe|*.1|*.msi|*.ipa|*.bin|*.app|*.jar|*.msu|*.msp|*.appx|*.appxbundle|*.xap|*.bat|*.cmd)
                    dest="/storage/emulated/0/下载/软件"
                    ;;
                *.sh|*.rc|*.java|*.js|*.json|*.vue|*.php|*.py|*.bat|*.gitignore|*.yml|*.go|*.c|*.cpp|*.h|*.hpp|*.tsx|*.vtt|*.srt|*.ass|*.rs|*.lrc|*.lua|*.pl|*.rb|*.html|*.css|*.xml|*.ini|*.conf|*.tex|*.md|*.csv|*.sql|*.log|*.bak|*.mdb|*.accdb|*.frm|*.ini|*.conf|*.properties|*.prop|*.gitignore)
                    dest="/storage/emulated/0/下载/脚本"
                    ;;
                *.m4v|*.M4V|*.MOV|*.MP4|*.mp4|*.avi|*.mov|*.rmvb|*.webm|*.flv|*.m3u8|*.mpg|*.mpeg|*.rm|*.wmv|*.swf|*.mkv|*.mts|*.m2ts|*.ts|*.vob|*.asf|*.dat|*.divx|*.xvid|*.3gp)
                    dest="/storage/emulated/0/下载/视频"
                    ;;
                *.doc|*.docx|*.pdf|*.rtf|*.odt|*.wps|*.pptx|*.xls|*.xlsx|*.ppt|*.odp|*.ods|*.pub|*.vsdx|*.key|*.txt|*.csv|*.xml|*.ini|*.conf|*.tex|*.md|*.html|*.htm|*.epub|*.djvu|*.mobi|*.azw|*.azw3|*.ibooks|*.chm|*.fb2|*.pdb|*.prc|*.ps|*.xps)
                    dest="/storage/emulated/0/下载/文档"
                    ;;
                *.mp3|*.wav|*.flac|*.ogg|*.m4a|*.opus|*.wma|*.mid|*.midi|*.ape|*.aac|*.ac3|*.amr|*.au|*.pcm)
                    dest="/storage/emulated/0/下载/音频"
                    ;;
                *.ttf|*.otf|*.woff|*.woff2|*.eot)
                    dest="/storage/emulated/0/下载/字体"
                    ;;
                *)
                    dest="/storage/emulated/0/下载/其他"
                    ;;
            esac

            check_dir "$dest"
            mv -f "$file" "$dest/"
            if [ $? -eq 0 ]; then                          
                if [ $size -lt $((5 * 1024 * 1024 * 1024)) ]; then
                    copy_and_remove "$file" "$dest/"
                fi
            fi
        fi
    done
}

check_dir "/storage/emulated/0/下载/"    
if [ -f "/storage/emulated/0/Android/luxus/文件归类/Route" ]; then
    while IFS= read -r path; do
        if [ -d "$path" ]; then
            set_permissions "$path"
            move_files "$path"
        fi
    done < "/storage/emulated/0/Android/luxus/文件归类/Route"
fi
