##########################################################################################
# Config Flags
##########################################################################################

# Set to true if you do *NOT* want Magisk to mount
# any files for you. Most modules would NOT want
# to set this flag to true
SKIPMOUNT=false

# Set to true if you need to load system.prop
PROPFILE=false

# Set to true if you need post-fs-data script
POSTFSDATA=false

# Set to true if you need late_start service script
LATESTARTSERVICE=true

##########################################################################################
# Installation Message
##########################################################################################

# Set what you want to show when installing your mod
print_modname() {
	return
}

##########################################################################################
# Replace list
##########################################################################################
# Construct your own list here, it will override the example above
# !DO NOT! remove this if you don't need to replace anything, leave it empty as it is now
SKIPUNZIP=0
REPLACE="
"
##########################################################################################
# Install
##########################################################################################
on_install() {
	$BOOTMODE || abort "
	!!! ONLY be installed on magisk. 
	!!! 仅支持在 Magisk 下安装。
	"
    [ $API -ge 26 ] || abort "
	!!! ONLY support Android8.0 (SDK26) or above. 
	!!! 仅支持 安卓8.0 及以上版本。
	"
    [ $MAGISK_VER_CODE -ge 21000 ] || abort "
	!!! ONLY support Magisk V21.0 or above. 
	!!! 仅支持 Magisk V21.0 及以上版本。
	"
    [ $ARCH == "arm64" ] || abort "
	!!! ONLY support ARM64 platform. 
	!!! 仅支持 ARM 64位 平台。
	"

	ORG_whitelist="/data/adb/modules/freezeit/whitelist.conf"
	BAK_whitelist="$TMPDIR/whitelist.conf"

	ORG_appname="/data/adb/modules/freezeit/appname.conf"
	BAK_appname="$TMPDIR/appname.conf"

	if [ -e $ORG_whitelist ];then
		echo "- 开始备份白名单文件"
		cp $ORG_whitelist $BAK_whitelist
	fi

	if [ -e $ORG_appname ];then
		echo "- 开始备份应用名称文件"
		cp $ORG_appname $BAK_appname
	fi
	
	echo "- 开始释放模块文件"
	unzip -o "$ZIPFILE" -x 'META-INF/*' -d $MODPATH >&2
	echo "- 释放完毕"

	if [ -e $BAK_whitelist ];then
		echo "- 恢复白名单文件"
		cp -f $BAK_whitelist $MODPATH/whitelist.conf
	fi

	if [ -e $BAK_appname ];then
		echo "- 恢复应用名称文件"
		cp -f $BAK_appname $MODPATH/appname.conf
	fi

	module_id="$(grep_prop id $MODPATH/module.prop)"
	module_name="$(grep_prop name $MODPATH/module.prop)"
	module_version="$(grep_prop version $MODPATH/module.prop)"
	module_author="$(grep_prop author $MODPATH/module.prop)"

	echo -e "\n********************************************"
	echo "  模块 Mod:  $module_name"
	echo "  识别  ID:  $module_id"
	echo "  版本 Ver:  $module_version"
	echo "  作者 Auh:  $module_author"
	echo -e "********************************************\n"

	apkPath="/data/local/tmp/freezeit.apk"
	cp "$MODPATH/freezeit.apk" $apkPath
	chmod 666 $apkPath

	echo "- 正在安装 [冻它APP]..."
	output=`pm install -r -f $apkPath`
	if [ $output == "Success" ]; then
		echo "- 安装 [冻它APP] 成功"
	else
		echo -e "- !!!\n- !!! 安装 [冻它APP] 失败: [$output]\n- !!!"
		mv -f $apkPath /sdcard
		echo -e "- 已将[ 冻它APP ]APK安装包释放到 内置存储根目录[ /sdcard ], 请手动安装\n"
	fi
	echo "- 模块安装流程完毕"

	echo -e "\n********************************************\n"
	cat $MODPATH/changelog.txt
	echo -e "\n********************************************\n"

	echo -e ""\
	"- 若出现奔溃日志 请反馈给作者提升模块质量，谢谢。 酷安 @JARK006\n"\
	"- If there is a crash log, Please feed back to the\n"\
	"  author to improve module compatibility. Thanks!\n"\
	"  Email: jark006@qq.com\n"\
	"  [ /sdcard/Android/freezeit_crash_xxxx-xxxx.txt ]\n\n"\
	"- 安装完毕，重启生效。\n"\
	"- Done. reboot to take effect.\n\n"

	rm -f /sdcard/Android/freezeit*
}

##########################################################################################
# Permissions
##########################################################################################
set_permissions() {
	# The following is default permissions, DO NOT remove
	set_perm_recursive $MODPATH  0  0  0755  0644
	set_perm_recursive $MODPATH/bin 0 0 0755 0755
}
