#!/bin/sh
# This file should be placed in $MODDIR/script

############
# Functions
############

# Magisk General Utility Functions <https://github.com/topjohnwu/Magisk/blob/master/scripts/util_functions.sh>
source /data/adb/magisk/util_functions.sh

errorexit() {
	# Print error info before exit sub script.
	ui_print "$1"
	exit 1
}

disavb() {
	AVB_flag=3 bash $MODSCRIPT/avb.sh
	find_boot_image
	install_magisk >/dev/null 2>&1
}

clone_perm() {
	local FILE NEW PERM PERMN OWNER GROUP CON
	FILE=$1; NEW=$2
	eval $(ls -l $FILE | awk -F " " '{printf("PERM=%s; OWNER=%s; GROUP=%s",$1,$3,$4)}');
	PERMN=$(echo $PERM | sed 's/^-//;s/\.//;y/rwx-/4210/;s/.\{1\}/& /g' | awk '{print $1+$2+$3""$4+$5+$6""$7+$8+$9}')
	CON=$(ls -Z $FILE | awk -F " " '{print $1}')
	set_perm $NEW $OWNER $GROUP $PERMN $CON
}

##########
# Presets
##########

WORKDIR=$(cd ${0%/*}; pwd);
# Variable MODDIR should be set in father script.
MODBIN=$MODDIR/bin
chmod +x $(find $MODBIN)
export PATH="$MODBIN:$PATH"
MODCONFIG=$MODDIR/config
MODSCRIPT=$MODDIR/script
MODSIGN=$MODDIR/sign
DAMCM=/data/adb/modules/coloros_mod
BACKUPDIR=/data/ColorOS_Mod
[ -d $BACKUPDIR ] || mkdir -p $BACKUPDIR

SLOT=`grep_cmdline androidboot.slot_suffix`
if [ -z $SLOT ]; then
	SLOT=`grep_cmdline androidboot.slot`
	[ -z $SLOT ] || SLOT=_${SLOT}
fi

VERID=$(getprop ro.build.display.id)

# Magisk’s BusyBox <https://topjohnwu.github.io/Magisk/guides.html#busybox>
bb=/data/adb/magisk/busybox

