#!/bin/sh
#
# This file is part of ColorOS_Mod.
# Copyright 2022 affggh and AzukiAtsui
#
# ColorOS_Mod is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# ColorOS_Mod is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with ColorOS_Mod.  If not, see <https://www.gnu.org/licenses/>.
#

MODDIR=${ColorOS_MOD_INSTALL_PATH:-$(cd ${0%/*/*};pwd)}
. ${0%/*}/util.sh

if [ "`cat /sys/devices/soc0/family`" != "Snapdragon" ]; then
	errorexit "E! Only support Snapdragon devices."
fi

LOGOSIGN=$MODSIGN/splash

WHICH_SCREEN=${WHICH_SCREEN:-boot.bmp}
PIC=$MODCONFIG/$WHICH_SCREEN

[ -z "$(opsplash | grep 'unpack')" ] && exit 15
[ -z "$($MODBIN/bash --version | grep 'version')" ] && exit 11

if [ "`ls /dev/block/by-name | grep splash$SLOT`" == "splash$SLOT" ];then
	BDN=splash;
elif [ "`ls /dev/block/by-name | grep logo$SLOT`" == "logo$SLOT" ];then
	# OnePlus 8 and later series running ColorOS.
	[ -z "`getprop ro.build.version.oplusrom`" ] || exit 7;
	BDN=logo;
else
	exit 6;
fi

[ -z $SLOT ] || SA=_a
BD=${BDN}${SA}
LOGOBK=$BACKUPDIR/splash
[[ -d $LOGOBK ]] || mkdir -p $LOGOBK
OGNLOGO=$LOGOBK/origin-$BD-${VERID}.img
NEWLOGO=$LOGOBK/new-$BD-${VERID}.img

SPLASHTMP=$MODDIR/splash
[[ -d $SPLASHTMP ]] || mkdir -p $SPLASHTMP

chkbmp() {
	f="$1"
	magic=`xxd -l 2 -p "$f"`
	recordsz=`od -A none -j 2 -N 4 -t d4 "$f" | tr -d " "`
	filesize=`stat -c %s "$f"`
	headersz=`od -A none -j 10 -N 1 -d "$f" | tr -d " "`
	# check header magic
	if [[ ! 424d == $magic ]]; then echo "E! Invalid bmp header!" >&2; return 1; fi
	# check file size
	if [[ ! $recordsz == $filesize ]]; then echo "E! File size not match with header!" >&2; return 1; fi
	# check header size/version
	if [[ ! $headersz == 54 ]]; then echo "E! Header version not bmp3!" >&2; return 1; fi
	return 0;
}

if [ -f $PIC ]; then
	chkbmp "$PIC"
	if [ "$?" -ne "0" ]; then
		errorexit "E! Invalid bmp image file."
	fi
else
	errorexit  "E! Not found $PIC."
fi

ckScn(){
	case $WHICH_SCREEN in
		fastboot.bmp) echo "FASTBOOT启动页";;
		verify.bmp) echo "系统文件被破坏 (system verify failed)";;
		boot_charger_low_battery3.bmp) echo "低电量 (low battery)";;
		boot.bmp) echo "开机第一屏 (standard 1st startup screen)";;
		boot_without_android.bmp) echo "不带安卓的开机 (boot_without_android)";;
		perversion.bmp) echo "未挂载my_分区时的android开机 (unmouting my_* slots (android) boot screen)";;
		engineering.bmp) echo "工程测试机开机 (engineering device boot screen)";;
		ExpSellLogo.bmp) echo "外销设备开机 (Export device boot screen)";;
		cmcctest.bmp) echo "中国移动开机 (CMCC boot screen)";;
		cmcc_with_android.bmp) echo "中国移动带安卓开机 (CMCC with Android boot screen)";;
		Telstra.bmp) echo "澳洲电信开机 (Telstra boot screen)";;
		realme.bmp) echo "realme";;
		CTSI31.bmp) echo "八一 (EGHIT ONE)";;
		YunLuTong.bmp) echo "云路通 (YunLuTong)";;
		GreenUmbrella.bmp) echo "小绿伞 (GreenUmbrella)";;
		perfect.bmp) echo "完美中国 (Perfect CN)";;
		foshanGov.bmp) echo "佛山政 (foshan Gov)";;
		CTSIPOLICE.bmp) echo "警察 (CTSIPOLICE)";;
		black.bmp) echo "纯黑 (total black)";;
		test.bmp) echo "2K TEST";;
		rf.bmp) echo "rf 测试 (rf test)";;
		at.bmp) echo "AT 电流测试 (AT electric current test)";;
		wlan.bmp) echo "WLAN 测试 (wlan test)";;
		*) echo "Unkwon $WHICH_SCREEN";;
	esac
}

main() {
	if [ ! -f $OGNLOGO ];then
		echo "- Backuping $BD block file to $OGNLOGO..." >&2;
		dd if="/dev/block/by-name/$BD" of="$OGNLOGO";
	else
		echo "- Existing $BD.img of current version: $OGNLOGO.";
	fi
	echo "- Unpacking $OGNLOGO.img..."
	cd $SPLASHTMP
	opsplash unpack -i $OGNLOGO -o "$SPLASHTMP/pic" >/dev/null 2>&1
		if [ "$?" -ne "0" ]; then
			errorexit "E! unpack failed."
		fi
	# echo "- Replacing $(ckScn) image file..."
	cp -f "$PIC" "$SPLASHTMP/pic/${PIC##*/}"
	opsplash repack -i $OGNLOGO -o "$NEWLOGO" >/dev/null 2>&1
		if [ "$?" -ne "0" ]; then
			errorexit "E! repack failed."
		fi
	rm -rf "$SPLASHTMP"

	disavb
	echo "- Flashing $BD..." >&2
	dd if="$NEWLOGO" of="/dev/block/by-name/$BD"
		if [ "$?" -eq "0" ]; then
			echo 1 >$LOGOSIGN
			exit 0
		fi
}

bk2up(){
	if [ ! -f $ORNLOGO ];then
		echo "I! Not found the EXTRACTED LOGO IMG of current version."
		rm -rf $LOGOBK
		mkdir -p $LOGOBK
		main
	fi
}

case $(cat $LOGOSIGN) in
	1) bk2up;;
	2)
		# recovery splash
		dd if=$OGNLOGO of=/dev/block/by-name/$BD
		echo "$OGNLOGO $BD" > $BACKUPDIR/splash.log
		;;
	3) bk2up;;
	*) main;;
esac
exit 255

