MODDIR=${0%/*}
SCENE_PATH="/data/data/com.omarea.vtools/files"
soc_model=$(getprop ro.soc.model)

if [ -z "$soc_model" ]; then 
    soc_model=$(getprop ro.hardware)
fi

while [ "$(getprop sys.boot_completed)" != "1" ]; do
    sleep 30
done
sleep 15
chmod 755 $SCENE_PATH

case "$soc_model" in
    "SM8650")
        cp -f $MODDIR/config/sm8650/*.json $SCENE_PATH
        sleep 3
        ;;
    "SM8550" | "SM7675")
        cp -f $MODDIR/config/sm8550/*.json $SCENE_PATH
        sleep 3
        ;;
    "SM8475" | "SM8450")
        cp -f $MODDIR/config/sm8475/*.json $SCENE_PATH
        sleep 3
        ;;
    "SM8350")
        cp -f $MODDIR/config/sm8350/*.json $SCENE_PATH
        sleep 3
        ;;
    "SM8250")
        cp -f $MODDIR/config/sm8250/*.json $SCENE_PATH
        sleep 3
        ;;
    "SM7475")
        cp -f $MODDIR/config/sm7475/*.json $SCENE_PATH
        sleep 3
        ;;
    "MT6983")
        cp -f $MODDIR/config/mt6983/*.json $SCENE_PATH
        sleep 3
        ;;
    "MT6896")
        cp -f $MODDIR/config/mt6896/*.json $SCENE_PATH
        sleep 3
        ;;
    "MT6895" | "MT6895Z/TCZA" | "MT6895Z_A/TCZA")
        cp -f $MODDIR/config/mt6895/*.json $SCENE_PATH
        sleep 3
        ;;
    "MT6893")
        cp -f $MODDIR/config/mt6893/*.json $SCENE_PATH
        sleep 3
        ;;
esac
