#!/system/bin/sh
MODDIR=${0%/*}
if [ ! -f "/data/EvoMem_config.conf" ]; then
cp -f $MODDIR/EvoMem_config.conf /data/
fi

EvoMem_config="/data/EvoMem_config.conf"
function get_prop() {
  cat $EvoMem_config | grep -v '^#' | grep "^$1=" | cut -f2 -d '='
}
switch_boot=$(get_prop switch_boot)
switch_fstrim=$(get_prop switch_fstrim)
switch_keepwrite=$(get_prop switch_keepwrite)
switch_cpuaffinity=$(get_prop switch_cpuaffinity)
switch_io=$(get_prop switch_io)
switch_mireclaim=$(get_prop switch_mireclaim)
switch_ppr=$(get_prop switch_ppr)

  if [[ "$switch_keepwrite" == 'true' ]]; then
    chmod +x $MODDIR/script/opt_writeback.sh
    $MODDIR/script/opt_writeback.sh > /cache/MemFusion.log 2>&1 &
    fi
  if [[ "$switch_cpuaffinity" == 'true' ]]; then
        sh $MODDIR/script/set_cpu_affinity.sh
    fi
  if [[ "$switch_io" == 'true' ]]; then
        sh $MODDIR/script/set_io.sh
    fi
  if [[ "$switch_mireclaim" == 'true' ]]; then
        sh $MODDIR/script/set_mi_reclaim.sh
    fi
  if [[ "$switch_ppr" == 'true' ]]; then
        sh $MODDIR/script/set_ppr.sh
    fi
  if [[ "$switch_boot" == 'true' ]]; then
        sh $MODDIR/script/opt_boot.sh
    fi
  if [[ "$switch_fstrim" == 'true' ]]; then
        sh $MODDIR/script/opt_fstrim.sh
    fi
