#!/bin/sh
#作者 响當當&HamJTY
BASEDIR="$(dirname $(readlink -f "$0"))"
log_path="/data/media/0/log_OTAFix.txt"
BOOT_A=$(realpath /dev/block/by-name/boot_a)
BOOT_B=$(realpath /dev/block/by-name/boot_b)
var_device="$(getprop ro.product.device)"
var_version="$(getprop ro.build.version.release)"
var_MIUI_version="$(getprop ro.miui.ui.version.name)"
grep_cmdline() {
    local REGEX="s/^$1=//p"
    {
        echo $(cat /proc/cmdline)$(sed -e 's/[^"]//g' -e 's/""//g' /proc/cmdline) | xargs -n 1
        sed -e 's/ = /=/g' -e 's/, /,/g' -e 's/"//g' /proc/bootconfig
    } 2>/dev/null | sed -n "$REGEX"
}
SLOT=$(grep_cmdline androidboot.slot_suffix)
BOOT_PART="/dev/null"
printMd5() {
    echo "$(md5sum $1/boot1.img | cut -d" " -f1) boot.img" >>$log_path 2>&1
    echo $(md5sum $BOOT_A) >>$log_path 2>&1
    echo $(md5sum $BOOT_B) >>$log_path 2>&1
}
#通过当前的slot决定要更改的分区
if [ -z $SLOT ]; then
    SLOT=$(grep_cmdline androidboot.slot)
    [ -z $SLOT ] || SLOT=_${SLOT}
fi
[ -z $SLOT ] || echo "- 当前启动槽位: $SLOT"
case $SLOT in
_a) BOOT_PART=$BOOT_A ;;
_b) BOOT_PART=$BOOT_B ;;
esac
#获取dev里面的sha1值
echo "- 获取Magisk配置"
source "$(find /dev -mindepth 2 -maxdepth 2 -name ".magisk" | head -n 1)/config"
#如果通过sha1值确定的目录找不到文件，则获取最新的目录
if [[ -d /data/magisk_backup_$SHA1 ]] && [[ -f /data/magisk_backup_$SHA1/boot.img.gz ]]; then
    dir=/data/magisk_backup_$SHA1
    echo "- 通过定位到最新的Magisk备份的官方启动镜像: ${dir}"
else
    dir="/data/$(ls -t /data | grep ^magisk | head -n 1)"
    echo "- 定位到最新的Magisk备份的官方启动镜像: ${dir}"
fi
# 不是A/B分区设备，强制退出并禁用
if [ -z $SLOT ]; then
    echo "不是(V-)A/B分区设备，停止运行!" >>$log_path 2>&1
    true >$BASEDIR/disabled
    exit 1
fi
# echo "- 当前Boot槽位: $SLOT" >>$log_path  2>&1
echo "- 当前修改槽位: $BOOT_PART" >>$log_path 2>&1
echo "- 设备: $var_device" >>$log_path 2>&1
echo "- 系统版本: $var_version" >>$log_path 2>&1
echo "- MIUI版本: $var_MIUI_version" >>$log_path 2>&1
echo "- 定位当前Magisk位置: ${dir}" >>$log_path 2>&1
# 存在备份，开始执行
if [ -f $dir/boot.img.gz ]; then
    echo "- 找到 boot.img.gz" >>$log_path 2>&1
    echo "- 解压 boot.img.gz" >>$log_path 2>&1
    cp $dir/boot.img.gz $dir/boot1.img.gz >>$log_path 2>&1
    gzip -d $dir/boot1.img.gz >>$log_path 2>&1
    echo "- 计算 MD5" >>$log_path 2>&1
    printMd5 $dir
    echo "- 删除当前boot_a和boot_b的链接" >>$log_path 2>&1
    rm $BOOT_PART
    echo "- 还原为官方boot.img" >>$log_path 2>&1
    case $SLOT in
    _a)
        cat $BOOT_A >$dir/boot_cur.img
        rm $BOOT_B
        mv $dir/boot_cur.img $BOOT_B
        ;;
    _b) cat $BOOT_B >$dir/boot_cur.img
        rm $BOOT_A
        mv $dir/boot_cur.img $BOOT_A ;;
    esac
    dd if=$dir/boot1.img of=$BOOT_PART
    echo "- 重新计算 MD5" >>$log_path 2>&1
    printMd5 $dir
    echo '- 删除缓存' >>$log_path 2>&1
    rm $dir/boot1.img >>$log_path 2>&1
    rm $dir/boot1_cur.img >>$log_path 2>&1
    echo "- 完成!" >>$log_path 2>&1
    # 不存在备份，结束执行，但不禁用模块
else
    echo '- 没有找到Magisk备份的官方启动镜像boot.img.gz，强制退出!' >>$log_path 2>&1
    # true >$BASEDIR/disabled
    exit 1
fi
