#!/system/bin/sh
# Please don't hardcode /magisk/modname/... ; instead, please use $MODDIR/...
# This will make your scripts compatible even if Magisk change its mount point in the future
MODDIR=${0%/*}

# This script will be executed in late_start service mode
# More info in the main Magisk thread

  
# Initd script for Snapdragon 835
sleep 6
C0_GOVERNOR_DIR="/sys/devices/system/cpu/cpu0/cpufreq"
C1_GOVERNOR_DIR="/sys/devices/system/cpu/cpu4/cpufreq"
C0_CPUFREQ_DIR="/sys/devices/system/cpu/cpu0/cpufreq"
C1_CPUFREQ_DIR="/sys/devices/system/cpu/cpu4/cpufreq"

# $1:timer_rate $2:value
function set_param_little() 
{
	echo ${2} > ${C0_GOVERNOR_DIR}/${1}
}

# $1:timer_rate $2:value
function set_param_big() 
{
	echo ${2} > ${C1_GOVERNOR_DIR}/${1}
}

# $1:value $2:file path
function set_value() 
{
	if [ -f $2 ]; then
		echo $1 > $2
	fi
}

# $1:value $2:file path
function lock_value() 
{
	if [ -f $2 ]; then
		# chown 0.0 $2
		chmod 0666 $2
		echo $1 > $2
		chmod 0444 $2
	fi
}

function unify_environment() 
{
	# SELinux permissive
	setenforce 0
	# disable hotplug to switch governor
	set_value 0 /sys/module/msm_thermal/core_control/enabled
	set_value N /sys/module/msm_thermal/parameters/enabled
	# in case of using ondemand as default governor
	lock_value "" ${C0_CPUFREQ_DIR}/scaling_governor
	lock_value "" ${C1_CPUFREQ_DIR}/scaling_governor
	# Perfd, nothing to worry about, if error the script will continue
	stop perfd
}

function before_modify()
{
	chown 0.0 ${C0_GOVERNOR_DIR}/*
	chmod 0666 ${C0_GOVERNOR_DIR}/*
	lock_value 280000 ${C0_CPUFREQ_DIR}/scaling_min_freq

	set_value 1 /sys/devices/system/cpu/cpu4/online
	chown 0.0 ${C1_GOVERNOR_DIR}/*
	chmod 0666 ${C1_GOVERNOR_DIR}/*
	lock_value 280000 ${C1_CPUFREQ_DIR}/scaling_min_freq
}

function runonce_custom()
{
	set_value 90 /proc/sys/kernel/sched_spill_load
	set_value 0 /proc/sys/kernel/sched_boost
	set_value 0 /proc/sys/kernel/sched_prefer_sync_wakee_to_waker
	set_value 40 /proc/sys/kernel/sched_init_task_load
	set_value 3000000 /proc/sys/kernel/sched_freq_inc_notify

	# avoid permission problem, do not set 0444
	set_value 2-3 /dev/cpuset/background/cpus
	set_value 0-3 /dev/cpuset/system-background/cpus
	set_value 0-3,4-7 /dev/cpuset/foreground/cpus
	set_value 0-3,4-7 /dev/cpuset/top-app/cpus

	# set_value 85 /proc/sys/kernel/sched_downmigrate
	# set_value 95 /proc/sys/kernel/sched_upmigrate

	lock_value 2500 /sys/module/cpu_boost/parameters/input_boost_ms
	lock_value 0 /sys/module/msm_performance/parameters/touchboost
	lock_value "0:380000 4:380000" /sys/module/cpu_boost/parameters/input_boost_freq

	set_param_little use_sched_load 0
	lock_value 0 ${C0_GOVERNOR_DIR}/ignore_hispeed_on_notif
	lock_value 0 ${C0_GOVERNOR_DIR}/enable_prediction
	set_param_big use_sched_load 0
	lock_value 0 ${C1_GOVERNOR_DIR}/ignore_hispeed_on_notif
	lock_value 0 ${C1_GOVERNOR_DIR}/enable_prediction
}

function after_modify()
{
	runonce_custom

	# interactive parameters
	#cpu0
	set_param_little timer_rate 20000
	set_param_little timer_slack 140000
	set_param_little boost 1
	set_param_little boostpulse_duration 15000
	set_param_little above_hispeed_delay 15000 1171000:17000
	set_param_little hispeed_freq 748000
	set_param_little go_hispeed_load 95
	set_param_little target_loads "60 300000:14 364000:19 441000:12 518000:24 672000:27 748000:18 883000:35 960000:27 1036000:41 1171000:34 1324000:49 1555000:47 1670000:63 1747000:47 1824000:72 1900000:58"
	set_param_little min_sample_time 3000
	set_param_little max_freq_hysteresis 3800
	#cpu4
	set_param_big timer_rate 20000
	set_param_big timer_slack 180000
	set_param_big boost 1
	set_param_big boostpulse_duration 15000
	set_param_big above_hispeed_delay 1500 1651000:1500
	set_param_big hispeed_freq 1267000
	set_param_big go_hispeed_load 95
	set_param_big target_loads "85 300000:15 345000:18 499000:11 576000:25 652000:27 729000:19 806000:31 902000:25 979000:39 1056000:41 1132000:32 1267000:48 1651000:63 1804000:69 1881000:43 2035000:79 2112000:53 2208000:88 2323000:92 2457000:96"
	set_param_big min_sample_time 3000
	set_param_big max_freq_hysteresis 3800
}

function RunOnce()
{
	unify_environment
	before_modify
	after_modify
}

RunOnce

#快c
#!/system/bin/sh
# Please don't hardcode /magisk/modname/... ; instead, please use $MODDIR/...
# This will make your scripts compatible even if Magisk change its mount point in the future
MODDIR=${0%/*}

# This script will be executed in late_start service mode
# More info in the main Magisk thread
echo 1 > /sys/class/power_supply/battery/allow_hvdcp3
chmod 755 /sys/class/power_supply/battery/constant_charge_current_max
echo `expr 5000 \* 1000` > /sys/class/power_supply/battery/constant_charge_current_max
chmod 755 /sys/class/power_supply/battery/input_current_max
echo `expr 5000 \* 1000` > /sys/class/power_supply/battery/input_current_max
chmod 755 /sys/class/power_supply/battery/voltage_max
echo 9000000 > /sys/class/power_supply/battery/voltage_max
echo 5000 > /sys/module/dwc3_msm/parameters/dcp_max_current
echo 5000 > /sys/module/dwc3_msm/parameters/hvdcp_max_current
echo 5000 > /sys/module/qpnp_smbcharger/parameters/default_dcp_icl_ma
echo 5000 > /sys/module/qpnp_smbcharger/parameters/default_hvdcp3_icl_ma
echo 5000 > /sys/module/qpnp_smbcharger/parameters/default_hvdcp_icl_ma
echo 500 >/sys/class/power_supply/bms/temp_warm
echo 100 >/sys/class/power_supply/bms/temp_cool

chmod 755 /sys/class/power_supply/battery/charge_control_limit_max
echo 99 > /sys/class/power_supply/battery/charge_control_limit_max
#RAM
#!/system/bin/sh
# Please don't hardcode /magisk/modname/... ; instead, please use $MODDIR/...
# This will make your scripts compatible even if Magisk change its mount point in the future
MODDIR=${0%/*}

# This script will be executed in late_start service mode
# More info in the main Magisk thread

# Wait..
			
		# Android UFS 2.1 I/O init.rc
        chown root root /sys/block/sda/queue/read_ahead_kb  
		chown 0644 /sys/block/sda/queue/read_ahead_kb  
		chown root root /sys/block/sda/queue/nr_requests
		chown 0644 /sys/block/sda/queue/nr_requests
		chown root root /sys/block/sde/queue/iosched/slice_idle 
		chown 0644 /sys/block/sde/queue/iosched/slice_idle 
		chown root root /sys/block/sde/queue/iosched/quantum
		chown 0644 /sys/block/sde/queue/iosched/quantum
		cho
			# RAM memory 
		echo 0 > /sys/module/lowmemorykiller/parameters/debug_level
		chown root root /sys/module/lowmemorykiller/parameters/debug_level
		chmod 0644 /sys/module/lowmemorykiller/parameters/debug_level
		echo 0 > /sys/module/subsystem_restart/parameters/enable_ramdumps
		chown root root /sys/module/subsystem_restart/parameters/enable_ramdumps
		chmod 0644 /sys/module/subsystem_restart/parameters/enable_ramdumps
		
		

