SKIPMOUNT=false
PROPFILE=true
POSTFSDATA=true
LATESTARTSERVICE=true
REPLACE=""

rm -rf /data/adb/modules/scene_swap_controller/
rm -rf /data/adb/modules_update/scene_swap_controller/
rm -rf /data/adb/swap-controller

echo "配置文件位于：/data/adb/swap_controller/swap.conf" >/data/swap_config.conf

update_system_prop() {
  local prop="$1"
  local value="$2"
  sed -i "s/^$prop=.*/$prop=$value/" /data/adb/swap_controller/keep.conf
}

print_modname() {

  # 获取模块版本号
  swap_version="$TMPDIR/module.prop"
  function get_prop() {
    cat $swap_version | grep -v '^#' | grep "^$1=" | cut -f2 -d '='
  }
  module=$(get_prop version)

  # 输出信息
  echo " ****************************************"
  echo "  ◆[超强保后台] 模块安装成功！"
  echo "  ☞模块版本：$module"
  echo "  ☞安装时间：$ins"
  echo "  ✔配置文件位置：请查看模块介绍"
  echo "  ✔你可以前往酷安关注我：“开心小阳光123”"
  echo " ****************************************"
}

# 检测内核支持的压缩方式
check_result1=`cat /sys/block/zram0/comp_algorithm | grep lz4`
check_result2=`cat /sys/block/zram0/comp_algorithm | grep zstd`
check_result3=`cat /sys/block/zram0/comp_algorithm | grep lzo-rle`
if [[ "$check_result1" != "" ]]; then
  comp_algorithm=lz4
elif [[ "$check_result2" != "" ]]; then
  comp_algorithm=zstd
elif [[ "$check_result3" != "" ]]; then
  comp_algorithm=lzo-rle
else
  comp_algorithm=lzo
fi

ins=$(date "+%m月%d日_%H时%M分")

# 创建配置参数
swap=false
swap_size=0
swap_priority=-2
swap_use_loop=false
zram=true
zram_size=6144
swappiness=100
min_free_kbytes=8192
extra_free_kbytes=8192
watermark_scale_factor=100
zram_writeback=false

on_install() {

# 开始安装
unzip -o "$ZIPFILE" 'system/*' -d $MODPATH >&2
[[ ! -d /data/adb/swap_controller ]] && mkdir -p /data/adb/swap_controller

# 读取参数
if [[ -f "/data/adb/swap_controller/keep.conf" ]]; then
function get_prop() {
  cat /data/adb/swap_controller/keep.conf | grep -v '^#' | grep "^$1=" | cut -f2 -d '='
}
current_swap=$(get_prop swap)
current_swap_size=$(get_prop swap_size)
current_swap_priority=$(get_prop swap_priority)
current_swap_use_loop=$(get_prop swap_use_loop)
current_zram=$(get_prop zram)
current_zram_size=$(get_prop zram_size)
current_comp_algorithm=$(get_prop comp_algorithm)
current_swappiness=$(get_prop swappiness)
current_min_free_kbytes=$(get_prop min_free_kbytes)
current_extra_free_kbytes=$(get_prop extra_free_kbytes)
current_watermark_scale_factor=$(get_prop watermark_scale_factor)
current_zram_writeback=$(get_prop zram_writeback)
current_writeback_size=$(get_prop writeback_size)
current_writeback_sleep=$(get_prop writeback_sleep)
current_writeback_number=$(get_prop writeback_number)
current_writeback_writeback=$(get_prop writeback_writeback)
cp -f ${TMPDIR}/keep.conf /data/adb/swap_controller
# 应用参数
if [[ "$current_swap" != "" ]]; then
swap="$current_swap"
update_system_prop swap $swap
fi
if [[ "$current_swap_size" != "" ]]; then
swap_size="$current_swap_size"
update_system_prop swap_size $swap_size
fi
if [[ "$current_swap_priority" != "" ]]; then
swap_priority="$current_swap_priority"
update_system_prop swap_priority $swap_priority
fi
if [[ "$current_swap_use_loop" != "" ]]; then
swap_use_loop="$current_swap_use_loop"
update_system_prop swap_use_loop $swap_use_loop
fi
if [[ "$current_zram" != "" ]]; then
zram="$current_zram"
update_system_prop zram $zram
fi
if [[ "$current_zram_size" != "" ]]; then
zram_size="$current_zram_size"
update_system_prop zram_size $zram_size
fi
if [[ "$current_comp_algorithm" != "" ]]; then
comp_algorithm="$current_comp_algorithm"
update_system_prop comp_algorithm $comp_algorithm
fi
if [[ "$current_swappiness" != "" ]]; then
swappiness="$current_swappiness"
update_system_prop swappiness $swappiness
fi
if [[ "$current_min_free_kbytes" != "" ]]; then
min_free_kbytes="$current_min_free_kbytes"
update_system_prop min_free_kbytes $min_free_kbytes
fi
if [[ "$current_extra_free_kbytes" != "" ]]; then
extra_free_kbytes="$current_extra_free_kbytes"
update_system_prop extra_free_kbytes $extra_free_kbytes
fi
if [[ "$current_watermark_scale_factor" != "" ]]; then
watermark_scale_factor="$current_watermark_scale_factor"
update_system_prop watermark_scale_factor $watermark_scale_factor
fi
if [[ "$current_zram_writeback" != "" ]]; then
zram_writeback="$current_zram_writeback"
update_system_prop zram_writeback $zram_writeback
fi
if [[ "$current_writeback_size" != "" ]]; then
writeback_size="$current_writeback_size"
update_system_prop writeback_size $writeback_size
fi
if [[ "$current_writeback_sleep" != "" ]]; then
writeback_sleep="$current_writeback_sleep"
update_system_prop writeback_sleep $writeback_sleep
fi
if [[ "$current_writeback_number" != "" ]]; then
writeback_number="$current_writeback_number"
update_system_prop writeback_number $writeback_number
fi
if [[ "$current_writeback_writeback" != "" ]]; then
writeback_writeback="$current_writeback_writeback"
update_system_prop writeback_writeback $writeback_writeback
fi
else
cp -f ${TMPDIR}/keep.conf /data/adb/swap_controller
fi

# 配置回写
if [[ -f '/sys/block/zram0/backing_dev' ]]; then
zram_writeback_config="
# 内存扩展 [回写]
# 作用：将zram压缩数据回写入磁盘，减少运存占用，缓解杀后台。
# ①开启说明：
# 需要开启系统内存扩展才能生效
# 模块将会自动运行简易内存扩展回写功能
# ②注意事项：
# 不开启回写不影响正常使用，亦不影响保后台功能
# 回写仅用于增加系统的可用运存量，且会带来少量的耗电和CPU占用
# 请谨慎选择是否开启！
zram_writeback=$zram_writeback
"
else
zram_writeback_config="
# 内核不支持内存扩展回写 [不影响正常使用]"
fi

echo "✔ 模块版本：$module
✔ 安装时间：$ins
✔ 除特殊说明外，true为开启，false为关闭
✔ 提示：正常情况下无需修改本页面的任何参数
✔ 注意：修改参数后，需要重启手机后才能生效
---------------------------------------------------------------------------
# 配置swapfile
swap=$swap

# swap大小 [MB]
# 修改后需手动删除/data/swapfile文件
swap_size=$swap_size

# swapfile使用顺序
# [0] 与zram同时使用
# [-2] 用完zram后再使用
# [5] 优先于zram使用
swap_priority=$swap_priority

# swapfile挂载为回环设备
swap_use_loop=$swap_use_loop
---------------------------------------------------------------------------
# 配置zram
zram=$zram

# zram大小 [MB]
zram_size=$zram_size

# zram压缩算法
# 常见的有lzo、lz4、zstd等，需要内核支持
comp_algorithm=$comp_algorithm

# swap积极性 [%]
swappiness=$swappiness

# 保留物理内存 [kbytes]
# 数值越大越易触发内存回收
min_free_kbytes=$min_free_kbytes
extra_free_kbytes=$extra_free_kbytes

# 内存水位线 [%]
# 数值越大内存回收越积极
watermark_scale_factor=$watermark_scale_factor
$zram_writeback_config" > /data/adb/swap_controller/swap.conf

# 复制文件
cp -f ${TMPDIR}/说明.txt /data/adb/swap_controller
}
