#!/system/bin/sh
# Do NOT assume where your module will be located.
# ALWAYS use $MODDIR if you need to know where this script
# and module is placed.
# This will make sure your module will still work
# if Magisk change its mount point in the future
MODDIR=${0%/*}

# This script will be executed in late_start service mode
sleep 30

su -c  cmd settings put global GPUTUNER_SWITCH true

nohup sh $MODDIR/script/technologyc > /dev/null &

sleep 30

# Cpu governor
chmod 644 /sys/devices/system/cpu/cpu0/cpufreq/scaling_governor
echo ondemand > /sys/devices/system/cpu/cpu0/cpufreq/scaling_governor
chmod 444 /sys/devices/system/cpu/cpu0/cpufreq/scaling_governor
chmod 644 /sys/devices/system/cpu/cpu1/cpufreq/scaling_governor
echo ondemand > /sys/devices/system/cpu/cpu1/cpufreq/scaling_governor
chmod 444 /sys/devices/system/cpu/cpu1/cpufreq/scaling_governor
chmod 644 /sys/devices/system/cpu/cpu2/cpufreq/scaling_governor
echo ondemand > /sys/devices/system/cpu/cpu2/cpufreq/scaling_governor
chmod 444 /sys/devices/system/cpu/cpu2/cpufreq/scaling_governor
chmod 644 /sys/devices/system/cpu/cpu3/cpufreq/scaling_governor
echo ondemand > /sys/devices/system/cpu/cpu3/cpufreq/scaling_governor
chmod 444 /sys/devices/system/cpu/cpu3/cpufreq/scaling_governor
chmod 644 /sys/devices/system/cpu/cpu4/cpufreq/scaling_governor
echo ondemand > /sys/devices/system/cpu/cpu4/cpufreq/scaling_governor
chmod 444 /sys/devices/system/cpu/cpu4/cpufreq/scaling_governor
chmod 644 /sys/devices/system/cpu/cpu5/cpufreq/scaling_governor
echo ondemand > /sys/devices/system/cpu/cpu5/cpufreq/scaling_governor
chmod 444 /sys/devices/system/cpu/cpu5/cpufreq/scaling_governor
chmod 644 /sys/devices/system/cpu/cpu6/cpufreq/scaling_governor
echo ondemand > /sys/devices/system/cpu/cpu6/cpufreq/scaling_governor
chmod 444 /sys/devices/system/cpu/cpu6/cpufreq/scaling_governor
chmod 644 /sys/devices/system/cpu/cpu7/cpufreq/scaling_governor
echo ondemand > /sys/devices/system/cpu/cpu7/cpufreq/scaling_governor
chmod 444 /sys/devices/system/cpu/cpu7/cpufreq/scaling_governor

# Qualcomm Technologyc
# Cpu Freq
echo 1804800 > /sys/devices/system/cpu/cpu0/cpufreq/scaling_max_freq
echo 1804800 > /sys/devices/system/cpu/cpu1/cpufreq/scaling_max_freq
echo 1804800 > /sys/devices/system/cpu/cpu2/cpufreq/scaling_max_freq
echo 1804800 > /sys/devices/system/cpu/cpu3/cpufreq/scaling_max_freq
echo 2419200 > /sys/devices/system/cpu/cpu4/cpufreq/scaling_max_freq
echo 2419200 > /sys/devices/system/cpu/cpu5/cpufreq/scaling_max_freq
echo 2419200 > /sys/devices/system/cpu/cpu6/cpufreq/scaling_max_freq
echo 3187200 > /sys/devices/system/cpu/cpu7/cpufreq/scaling_max_freq

# Runtime performance
echo 128 > /sys/block/sda/queue/read_ahead_kb
echo 128 > /sys/block/sda/queue/nr_requests
echo 1 > /sys/block/sda/queue/iostats
echo 128 > /sys/block/sdb/queue/read_ahead_kb
echo 128 > /sys/block/sdb/queue/nr_requests
echo 1 > /sys/block/sdb/queue/iostats
echo 128 > /sys/block/sdc/queue/read_ahead_kb
echo 128 > /sys/block/sdc/queue/nr_requests
echo 1 > /sys/block/sdc/queue/iostats
echo 128 > /sys/block/sdd/queue/read_ahead_kb
echo 128 > /sys/block/sdd/queue/nr_requests
echo 1 > /sys/block/sdd/queue/iostats
echo 128 > /sys/block/sde/queue/read_ahead_kb
echo 128 > /sys/block/sde/queue/nr_requests
echo 1 > /sys/block/sde/queue/iostats
echo 128 > /sys/block/sdf/queue/read_ahead_kb
echo 128 > /sys/block/sdf/queue/nr_requests
echo 1 > /sys/block/sdf/queue/iostats
echo 128 > /sys/block/dm-0/queue/read_ahead_kb
echo 128 > /sys/block/dm-1/queue/read_ahead_kb
echo 128 > /sys/block/dm-2/queue/read_ahead_kb
echo 128 > /sys/block/dm-3/queue/read_ahead_kb

# stune boost
echo 10 > /dev/stune/background/schedtune.boost
echo 10 > /dev/stune/foreground/schedtune.boost
echo 40 > /dev/stune/rt/schedtune.boost
echo 10 > /dev/stune/top-app/schedtune.boost
echo 10 > /dev/stune/schedtune.boost
echo 1 > /dev/stune/nnapi-hal/schedtune.boost
echo 0 > /dev/stune/nnapi-hal/schedtune.prefer_idle
echo 0 > /dev/stune/top-app/schedtune.prefer_idle
echo 0 > /dev/stune/background/schedtune.prefer_idle
echo 0 > /dev/stune/foreground/schedtune.prefer_idle
echo 0 > /dev/stune/rt/schedtune.prefer_idle
echo 0 > /dev/stune/schedtune.prefer_idle

# Cpu 0-3
echo 0 > /sys/devices/system/cpu/cpufreq/policy0/ondemand/ignore_nice_load
echo 0 > /sys/devices/system/cpu/cpufreq/policy0/ondemand/io_is_busy
echo 0 > /sys/devices/system/cpu/cpufreq/policy0/ondemand/powersave_bias
echo 100 > /sys/devices/system/cpu/cpufreq/policy0/ondemand/sampling_down_factor
echo 20000 > /sys/devices/system/cpu/cpufreq/policy0/ondemand/sampling_rate
echo 50 > /sys/devices/system/cpu/cpufreq/policy0/ondemand/up_threshold

# Cpu 4-6
echo 0 > /sys/devices/system/cpu/cpufreq/policy4/ondemand/ignore_nice_load
echo 0 > /sys/devices/system/cpu/cpufreq/policy4/ondemand/io_is_busy
echo 0 > /sys/devices/system/cpu/cpufreq/policy4/ondemand/powersave_bias
echo 100 > /sys/devices/system/cpu/cpufreq/policy4/ondemand/sampling_down_factor
echo 20000 > /sys/devices/system/cpu/cpufreq/policy4/ondemand/sampling_rate
echo 50 > /sys/devices/system/cpu/cpufreq/policy4/ondemand/up_threshold

# Cpu 7
echo 0 > /sys/devices/system/cpu/cpufreq/policy7/ondemand/ignore_nice_load
echo 0 > /sys/devices/system/cpu/cpufreq/policy7/ondemand/io_is_busy
echo 0 > /sys/devices/system/cpu/cpufreq/policy7/ondemand/powersave_bias
echo 100 > /sys/devices/system/cpu/cpufreq/policy7/ondemand/sampling_down_factor
echo 20000 > /sys/devices/system/cpu/cpufreq/policy7/ondemand/sampling_rate
echo 50 > /sys/devices/system/cpu/cpufreq/policy7/ondemand/up_threshold
   
# Better Battery Efficient
echo N > /sys/module/workqueue/parameters/power_efficient
echo N > /sys/module/battery_saver/parameters/enabled

# fsync      
echo N > /sys/module/sync/parameters/fsync_enabled

# GPU Settings
echo 3 > /sys/module/msm_drm/parameters/boost_gpu
echo 3 > /sys/module/devfreq_boost/parameters/boost_gpu
echo 3 > /sys/kernel/gpu/gpu_boost
echo 0 > /sys/class/kgsl/kgsl-3d0/throttling
echo 1 > /sys/class/kgsl/kgsl-3d0/bus_split
echo 0 > /sys/class/kgsl/kgsl-3d0/force_bus_on
echo 0 > /sys/class/kgsl/kgsl-3d0/force_rail_on
echo 0 > /sys/class/kgsl/kgsl-3d0/force_clk_on
echo 3 > /sys/class/kgsl/kgsl-3d0/devfreq/adrenoboost

# ZRAM
echo 2048 > /sys/block/zram0/queue/read_ahead_kb

# better idling
echo 0-3 > /dev/cpuset/restricted/cpus

# Power Saving
echo freeze mem > /sys/power/state
echo s2idle [deep] > /sys/power/mem_sleep

sleep 30

# Fast Charger
chmod 0777 /sys/kernel/fast_charge/force_fast_charge
echo 1 > /sys/kernel/fast_charge/force_fast_charge
chmod 0444 /sys/kernel/fast_charge/force_fast_charge

chmod 0777 /sys/class/power_supply/battery/constant_charge_current_max
echo 4500000 > /sys/class/power_supply/battery/constant_charge_current_max
chmod 0444 /sys/class/power_supply/battery/constant_charge_current_max

chmod 0755 /sys/class/power_supply/battery/input_current_limited
echo 0 > /sys/class/power_supply/battery/input_current_limited
chmod 0644 /sys/class/power_supply/battery/input_current_limited

chmod 0755 /sys/class/power_supply/battery/step_charging_enabled
echo 1 > /sys/class/power_supply/battery/step_charging_enabled
chmod 0644 /sys/class/power_supply/battery/step_charging_enabled

chmod 0755 /sys/class/power_supply/battery/sw_jeita_enabled
echo 0 > /sys/class/power_supply/battery/sw_jeita_enabled
chmod 0644 /sys/class/power_supply/battery/sw_jeita_enabled

chmod 0755 /sys/class/power_supply/battery/battery_charging_enabled
echo 1 > /sys/class/power_supply/battery/battery_charging_enabled
chmod 0644 /sys/class/power_supply/battery/battery_charging_enabled

chmod 0755 /sys/class/power_supply/battery/subsystem/usb/pd_active
echo 0 > /sys/class/power_supply/battery/subsystem/usb/pd_active
chmod 0644 /sys/class/power_supply/battery/subsystem/usb/pd_active

chmod 0755 /sys/class/qcom-battery/restrict_chg
echo 0 > /sys/class/qcom-battery/restrict_chg
chmod 0644 /sys/class/qcom-battery/restrict_chg

chmod 0755 /sys/block/sda/quene/iostats
echo 0 > /sys/block/sda/queue/iostats
chmod 0644 /sys/block/sda/quene/iostats

chmod 0755 /proc/sys/kernel/sched_boost
echo 0 > /proc/sys/kernel/sched_boost
chmod 0644 /proc/sys/kernel/sched_boost

chmod 0755 /sys/module/lpm_levels/parameters/sleep_disabled
echo Y > /sys/module/lpm_levels/parameters/sleep_disabled
chmod 0644 /sys/module/lpm_levels/parameters/sleep_disabled

chmod 0755 /sys/module/sync/parameters/fsync_enabled
echo N > /sys/module/sync/parameters/fsync_enabled
chmod 0644 /sys/module/sync/parameters/fsync_enabled

