
set_perm() {
  chown $2:$3 $1 || return 1
  chmod $4 $1 || return 1
  local CON=$5
  [ -z $CON ] && CON=u:object_r:system_file:s0
  chcon $CON $1 || return 1
}

set_perm_recursive() {
  find $1 -type d 2>/dev/null | while read dir; do
    set_perm $dir $2 $3 $4 $6
  done
  find $1 -type f -o -type l 2>/dev/null | while read file; do
    set_perm $file $2 $3 $5 $6
  done
}

restart() {
 stop $1
 start $1
}
# 定义目录路径
base_dir="/data/odm/etc/gs2/9999"
def_dir="$base_dir/def"
soft_dir="$base_dir/soft"
json=$(printf '{\n      "9999" : {\n      "def_style" : [\n')
echo "$json" >vibrator_effect.json
# 遍历def文件夹下的文件
for file in "$def_dir"/effect_*.bin; do
  effect_id=$(basename "$file" | sed -E 's/effect_([0-9]+)\.bin/\1/')
  json=$(printf '         {\n            "effect_id" : %d,\n            "effect_file" : "%s",\n            "play_rate_hz" : 24000\n         },' "$effect_id" "$file")
  echo "$json" >>vibrator_effect.json
done
sed -i '$s/.$//' vibrator_effect.json
json=$(printf '      ],\n      "soft_style" : [')
echo "$json" >>vibrator_effect.json
# 遍历soft文件夹下的文件
for file in "$soft_dir"/effect_*.bin; do
  effect_id=$(basename "$file" | sed -E 's/effect_([0-9]+)\.bin/\1/')
  json=$(printf '         {\n            "effect_file" : "%s",\n            "effect_id" : %d,\n            "play_rate_hz" : 24000\n         },' "$file" "$effect_id")
  echo "$json" >>vibrator_effect.json
done
sed -i '$s/.$//' vibrator_effect.json
json=$(printf '      ]\n   },\n   "vibrator_arch" : "qcom-hv-haptic"\n}')
echo "$json" >>vibrator_effect.json
set_perm_recursive  /data/odm/etc/gs2/9999     0     0         0755      0644     u:object_r:vendor_configs_file:s0
set_perm_recursive /data/odm/etc/gs2/vibrator_effect.json  0 0 0644 0644     u:object_r:vendor_configs_file:s0
restart vendor.oplus.vibrator
