function boot(){
while true;
do
btcplt=$(getprop vendor.oplus.boot_complete)
if [ "$btcplt" -eq "1" ];then
	return 0
fi
sleep 1
done
}
boot
#mkdir -p /storage/emulated/0/Android/gs_vibrator

cd /sys/class/qcom-haptics/
echo 8000 >cl_vmax
echo 10000 >fifo_vmax
echo 2830 >vmax

set_perm() {
  chown $2:$3 $1 || return 1
  chmod $4 $1 || return 1
  local CON=$5
  [ -z $CON ] && CON=u:object_r:system_file:s0
  chcon $CON $1 || return 1
}

set_perm_recursive() {
  find $1 -type d 2>/dev/null | while read dir; do
    set_perm $dir $2 $3 $4 $6
  done
  find $1 -type f -o -type l 2>/dev/null | while read file; do
    set_perm $file $2 $3 $5 $6
  done
}

restart() {
 stop $1
 start $1
}
#set_perm_recursive  /data/odm/etc/gs2/9999     0     0         0755      0644     u:object_r:vendor_configs_file:s0

# 为了简化处理，我们假设JSON文件格式是固定的，且每个effect都占据多行，其中包含effect_id和effect_file字段。
# 该脚本将在匹配到effect_id之后，在下一行寻找effect_file并进行替换。

# 读取efmap.txt文件并更新vibrator_effect.json
while IFS= read -r line || [[ -n "$line" ]]; do
  # 忽略注释行
  if [[ $line != \#* ]]; then
    # 分割行并提取effect_id和新的effect_value
    effect_id=$(echo "$line" | cut -d'=' -f1 | sed 's/effect_//')
    effect_value=$(echo "$line" | cut -d'=' -f2)

    # 构建sed替换模式
    # 匹配包含指定effect_id的行，然后替换紧接着的effect_file行中的文件编号
    sed -i -e "/\"effect_id\" : $effect_id,/!b; n; s|effect_[0-9]*\.bin|effect_$effect_value.bin|" /data/odm/etc/gs2/vibrator_effect.json
  fi
done < /storage/emulated/0/Android/gs_vibrator/efmap.txt
set_perm_recursive /data/odm/etc/gs2/vibrator_effect.json      0     0         0644      0644     u:object_r:vendor_configs_file:s0
restart vendor.oplus.vibrator
restart vendor.qti.vibrator
