#!/system/bin/sh
MODDIR=${0%/*}

# 变量1: 查询目前ZRAM写回回环设备路径
# 仅适用于启用内存扩展下运行, 我不想写一遍if判断条件
loop=$(cat /sys/block/zram0/backing_dev | grep -o "loop[0-9]*")

# 目标1: 将目标loop回环设备切换为无调度器模式
echo "none" > /sys/block/$loop/queue/scheduler

# 更改说明 原文(Github: https://github.com/xNombre/msm-4.14/commit/5d20629f)
# loop: Select I/O scheduler 'none' from inside add_disk()
# We noticed that the user interface of Android devices becomes very slow
# under memory pressure. This is because Android uses the zram driver on top
# of the loop driver for swapping, because under memory pressure the swap
# code alternates reads and writes quickly, because mq-deadline is the
# default scheduler for loop devices and because mq-deadline delays writes by
# five seconds for such a workload with default settings. Fix this by making
# the kernel select I/O scheduler 'none' from inside add_disk() for loop
# devices. This default can be overridden at any time from user space,
# e.g. via a udev rule. This approach has an advantage compared to changing
# the I/O scheduler from userspace from 'mq-deadline' into 'none', namely
# that synchronize_rcu() does not get called.
# Additionally, this patch reduces the Android boot time on my test setup
# with 0.5 seconds compared to configuring the loop I/O scheduler from user
# space.

#DEBUG代码部分
# 查询是否已更改为none
#cat /sys/block/$loop/queue/scheduler
# 切换为SSD模式
#echo "0" > /sys/block/$loop/queue/rotational
# By Amktiao(水龙) and Fangfang(方方) and Bart Van Assche(提交原始提供者)
