#!/system/bin/sh

function echo_init_svc(){
	getprop | grep 'init.svc.' | sed 's|\]\:.*\[.*||g;s|\[init.svc.||g'
}

function get_svc(){
	echo_init_svc | grep -iw "$1"
}

function set_svc(){
test -z "$2" && return 1
	local service=`get_svc "$2" `
		local control="$1"
		setprop "ctl.$control" "$service"
		sleep 1s
	pgrep -f "$service" | while read pid ;do
		kill -15 "$pid"
		kill -9 "$pid"
	done
if test -z "$service" ;then
		echo -e "\n服务不存在或未注册！"
	else
		echo -e "\n服务:$service 状态:$(getprop init.svc.$service)"
fi
}

sleep 2.5m
set_svc "stop" "cnss_diag"
set_svc "stop" "tcpdump"





