id="$id"
Magisk_mod=$(grep -w -q 'lite_modules' /data/adb/magisk/util_functions.sh && echo "lite_modules" || echo "modules")
local_MODPATH="/data/adb/$Magisk_mod/$id"
conf_file="${MODPATH}/配置.prop"
target_file="$local_MODPATH/配置.prop"
test ! -f "$target_file" && target_file="$local_MODPATH/配置.conf"

function show_value() {
	local value=$1
	local file="${2}"
	cat "${file}" | grep -E "(^$value=)" | sed '/^#/d;/^[[:space:]]*$/d;s/.*=//g' | sed 's/，/,/g;s/——/-/g;s/：/:/g'
}

function replace_value() {
	local name="${1}"
	local value="$(show_value "${name}" "${target_file}" )"
	local file="${2}"
	if test "$value" != "" ;then
		sed -i "s|^.*$name=.*|$name=$value|g" $file
		echo " 修改 [ $name ] 值为 [ $value ]"
	else 
		echo "添加新的配置选项 [ $name ] 值为 [ $(show_value "${name}" "$conf_file") ]"
	fi
}


if test -e $target_file ;then
	if test $(show_value "读取配置" "${conf_file}" ) == 否 ;then
		return 0
	else
		echo ""
		echo "∞————————————————————————∞"
		echo ""
		echo "- 读取上次修改的配置……"
		for i in $(cat "$conf_file" | sed '/^#/d;/^[[:space:]]*$/d;s/=.*//g' | sed '/^读取配置/d' )
		do
			replace_value "$i" "$conf_file"
		done
		echo ""
		echo "- 完成！"
		echo ""
		echo "∞————————————————————————∞"
	fi
fi


