#!/system/bin/sh


function correctpath(){
case `echo "$1"` in
	/system_ext* | /vendor* | /product* )
		echo "/system"$1""
	;;
	/system* )
		echo "$1"
	;;
esac
}

function unlock_thermal(){
local target="${1}" 
/data/adb/magisk/busybox chattr -R -i "${target}" >/dev/null 2>&1
/data/adb/magisk/busybox chattr -R -i "${target%/*}" >/dev/null 2>&1
}


unlock_thermal "/data/thermal/config"
unlock_thermal "/data/vendor/thermal/config"

echo -e "- 查找其他温控文件！\n"
find /system /system_ext /vendor /product -iname '*thermal*' -type f  2> /dev/null | sed '/.*android.*/d;/.*libthermalclient.*/d;/.*thermal-engine.*/d;/.*thermal.*conf/d;/.*hardware.*/d;/.*mi_thermald.*/d' | while read file ;do
file=$(correctpath $file  )
if test -n $file ;then
	mkdir -p $MODPATH${file%/*}
	touch $MODPATH$file && echo "成功替换: $file"
fi
done
echo -e "\n∞————————————————————————∞\n"


