#!/system/bin/sh
MODDIR=${0%/*}
BUSYBOXDIR=$MODDIR/busybox
export PATH=/system/bin:$BUSYBOXDIR:$PATH

wait_until_login() {
	# in case of /data encryption is disabled
	while [ "$(getprop sys.boot_completed)" != "1" ]; do
		sleep 1
	done
	# we doesn't have the permission to rw "/sdcard" before the user unlocks the screen
	local test_file="/sdcard/Android/.PERMISSION_TEST"
	true >"$test_file"
	while [ ! -f "$test_file" ]; do
		true >"$test_file"
		sleep 1
	done
	rm "$test_file"
}

wait_until_login

test -e $MODDIR/crond && {
chmod -R 777 $MODDIR/crond
crond -c $MODDIR/crond
}

test -e $MODDIR/mod && {
	chmod -R 777 $MODDIR/mod
	until $(dumpsys deviceidle get screen) ;do
		sleep 5
	done
	for i in $MODDIR/mod/*.sh ;do
		nohup $i >/dev/null 2>&1 &
	done
}

