#!/system/bin/sh

function unlock_thermal(){
local target="${1}" 
/data/adb/magisk/busybox chattr -R -i "${target}" >/dev/null 2>&1
/data/adb/magisk/busybox chattr -R -i "${target%/*}" >/dev/null 2>&1
}

function correctpath(){
case `echo "$1"` in
	/system_ext* | /vendor* | /product* )
		echo "/system"$1""
	;;
	/system* )
		echo "$1"
	;;
esac
}


unlock_thermal "/data/thermal/config"
unlock_thermal "/data/vendor/thermal/config"


dir="${0%/*}"
MODPATH="${dir%/*}"


#读取配置
function show_value() {
	local value=$1
	local file="${MODPATH}/配置.prop"
	cat "${file}" | grep -E "(^$value=)" | sed '/^#/d;/^[[:space:]]*$/d;s/.*=//g' | sed 's/，/,/g;s/——/-/g;s/：/:/g'
}

target_thermal="$(show_value '温控配置')"
conf_file="${MODPATH}/thermal/$target_thermal.conf"


if test -f "$conf_file" ;then
	echo "- 您已选择 [ $target_thermal ℃ ]！"
	cp -rf "$conf_file" "${MODPATH}/system/vendor/etc/thermal-normal.conf"
else
	echo "- 不存在配置文件！"
	echo "- 自动选择46℃温控文件！"
	cp -rf "${MODPATH}/thermal/46.conf" "${MODPATH}/system/vendor/etc/thermal-normal.conf"
fi

find /system /system_ext /vendor /product -iname '*thermal*.conf' -type f 2>/dev/null | sed '/thermal-map.*.conf/d'  2> /dev/null | while read file ;do
	echo "$( correctpath "$file" )" >> "$MODPATH/thermal_list.txt"
done

echo "$(cat "$MODPATH/thermal_list.txt" | sort | uniq )" > "$MODPATH/thermal_list.txt"

for i in $(ls $MODPATH/system/vendor/etc)
do
	sed -i "/$i/d" "$MODPATH/thermal_list.txt"
done

cat "$MODPATH/thermal_list.txt" | while read file ;do
	if test "$(show_value '温控配置')" = "nolimit" ;then
		test "$(echo "${file}" | grep -E 'tgame|mgame' )" != "" && continue
	fi
		mkdir -p "${MODPATH}/${file%/*}"
	cp -rf "${MODPATH}/system/vendor/etc/thermal-normal.conf" "$MODPATH/${file}"
done

if test "$(show_value '游戏温控配置')" = "是" ;then
	find /system /system_ext /vendor /product -iname '*thermal*tgame*.conf' -type f 2>/dev/null | while read file ;do
		truely_path=`correctpath "$file"`
			mkdir -p "$MODPATH/${truely_path%/*}"
	cp -rf ${MODPATH}/thermal/thermal-tgame.conf "$MODPATH/$truely_path"
	done
	find /system /system_ext /vendor /product -iname '*thermal*mgame*.conf' -type f 2>/dev/null | while read file ;do
		truely_path=`correctpath "$file"`
			mkdir -p "$MODPATH/${truely_path%/*}"
	cp -rf ${MODPATH}/thermal/thermal-mgame.conf "$MODPATH/$truely_path"
	done
fi

rm -rf "$MODPATH/thermal_list.txt"

thermal_dir="${MODPATH}/system/vendor/etc"
target="/data/vendor/thermal/config"

mkdir -p "$target"
cp -rf $thermal_dir/* $target

sed -i '/description=/d' "$MODPATH/module.prop"
sed -i "/author=.*/a\description= 当前已选择[ $target_thermal ]。温度配置可以在[ $MODPATH/配置.prop ]下选择，有[ 43℃，46℃，48℃，无限制 ]几种选择，更改完执行[ $MODPATH/service.sh ]就行，无需重启。" "$MODPATH/module.prop"



