#!/system/bin/sh

function correctpath(){
case `echo "$1"` in
	/system_ext* | /vendor* | /product* )
		echo "/system"$1""
	;;
	/system* )
		echo "$1"
	;;
esac
}

find /system /system_ext /vendor /product -iname '*thermal*.conf' -type f 2>/dev/null | sed '/thermal.*map.*.conf/d' | while read file ;do
	echo "$( correctpath "$file" )" >> "$TMPDIR/thermal_list.txt"
done

echo "$(cat "$TMPDIR/thermal_list.txt" | sort | uniq )" > "$TMPDIR/thermal_list.txt"

for i in $(ls $MODPATH/system/vendor/etc)
do
	sed -i "/$i/d" "$TMPDIR/thermal_list.txt"
done

cat "$TMPDIR/thermal_list.txt" | while read file ;do
	if test "$(show_value '温控配置')" = "nolimit" ;then
		test "$(echo "${file}" | grep -E 'tgame|mgame' )" != "" && continue
	fi
		mkdir -p "${MODPATH}/${file%/*}"
	cp -rf "${MODPATH}/system/vendor/etc/thermal-normal.conf" "$MODPATH${file}"
done

find /system /system_ext /vendor /product -iname '*thermal*map*.conf' -type f 2>/dev/null | while read file ;do
size="$(du -k $file | awk '{print $1}' | tr -cd '[0-9]'  )"
details="$(cat $file 2>/dev/null | sed 's/[[:space:]]//g;s|/n||g' )"
if test -f "$file" -a "$size" -ge "1" -a "$details" != "" ;then
	file="$( correctpath "$file" )"
		mkdir -p "${MODPATH}/${file%/*}"
	cp -rf "${file}" "${MODPATH}/${file}"
fi
done

if test "$(show_value '游戏温控配置')" = "是" ;then
	find /system /system_ext /vendor /product -iname '*thermal*tgame*.conf' -type f 2>/dev/null | while read file ;do
		truely_path=`correctpath "$file"`
			mkdir -p "$MODPATH/${truely_path%/*}"
	cp -rf ${MODPATH}/thermal/thermal-tgame.conf "$MODPATH/$truely_path"
	done
	find /system /system_ext /vendor /product -iname '*thermal*mgame*.conf' -type f 2>/dev/null | while read file ;do
		truely_path=`correctpath "$file"`
			mkdir -p "$MODPATH/${truely_path%/*}"
	cp -rf ${MODPATH}/thermal/thermal-mgame.conf "$MODPATH/$truely_path"
	done
fi

rm -rf /data/vendor/thermal
mkdir -p /data/vendor/thermal/config

cp -rf $MODPATH/system/vendor/etc/* /data/vendor/thermal/config

