#!/system/bin/sh

function install_magisk_busybox() {
mkdir -p /data/adb/busybox
/data/adb/magisk/busybox --install -s /data/adb/busybox
chmod -R 0755 /data/adb/busybox 
export PATH=/data/adb/busybox:$PATH
}

#添加busybox，避免参数无用。
install_magisk_busybox

#死循环快充，已经弃用！
#sleep_time="${2}m"

#限制电流数值
limit_current="5500000"
#脚本文件
script_file="${0%/*}/charge.sh"
#删除旧的脚本
test -f "${script_file}" && rm -rf "${script_file}"

#模块的函数支持
function print_head() {
cat << key

export PATH=/data/adb/busybox:\$PATH


function battery_status() {
	dumpsys battery | grep 'status' | grep -Eo "[0-9]"
}

function key_echo(){
test -f "\${2}" && {
	chmod 0644 "\${2}" 
	echo "\${1}" > "\${2}"
	}
}

limit_current="$limit_current"

key
}


function limit_current() {
	local file="$1"
	test -f "$file" && {
		local value="$(cat $file)"
		#echo "存在 $file 值：$value "
cat<<key
			key_echo "\$limit_current" $file
key
	}
}

function check_restrict() {
	local file="$1"
	test -f "$file" && {
		local value="$(cat $file)"
		#echo "存在 $file 值：$value "
cat<<key
			key_echo "1" $file
key
	}
}

function check_limit() {
	local file="$1"
	test -f "$file" && {
		local value="$(cat $file)"
		#echo "存在 $file 值：$value "
cat<<key
			key_echo "0" $file
key
	}
}


function echo_current(){
		find /sys -iname "hw_current_max" -o -iname "pd_current_max" -o -iname "constant_charge_current_max" -o -iname "restricted_current" -o -iname "current_max" -o -iname "thermal_input_current" -o -iname "fast_charge_current"  2> /dev/null | while read i ;do
local current=$(cat ${i})
test "$(echo "$current" | grep -w '\-' )" != "" && continue
test "$current" = "0" && continue
test "$current" = "1" && continue
		limit_current "$i"
	done
}

function echo_restrict(){
	find /sys -iname "input_current_settled" -o -iname "force_fast_charge" -o -iname "pd_allowed" -o -iname "allow_hvdcp3" 2> /dev/null | while read restrict ;do
	check_restrict "$restrict"
done
}

function echo_limit(){
	find /sys -iname "input_current_limited" -o -iname "restricted_charging" -o -iname "step_charging_enabled" 2> /dev/null | while read limit ;do
	check_limit "$limit"
done
}


function find_current(){
	find /sys -iname "*current*max" -type f -o -iname "charge*current*" -type f 2> /dev/null | while read value ;do
	limit_current "$value"
done
}



function mode_1(){
cat <<key>${script_file}

$(print_head)

while :; do
	if test "\$(battery_status)" = "2" ;then
$(echo_current)
$(echo_restrict)
$(echo_limit)
		sleep 1s
	else
		sleep $sleep_time
	fi
done
key
}

function mode_2(){
cat <<key>${script_file}

$(print_head)
a="0"
while :; do
$(echo_current)
$(echo_restrict)
$(echo_limit)
		a=\$((\$a + 1))
	test "\$a" = "5" && break
done
key
}

#输出并且运行脚本
mode_2 && {
chmod -R 0777 "${script_file%/*}"
nohup "${script_file}" & >/dev/null 2>&1
}

