#!/system/bin/sh
SKIPUNZIP=0
my_grep_prop() {
  local REGEX="s/$1=//p"
  shift
  local FILES=$@
  [ -z "$FILES" ] && FILES='/system/build.prop /vendor/build.prop /product/build.prop'
  sed -n "$REGEX" $FILES 2>/dev/null | head -n 1
}
starttime=$(date +"%Y-%m-%d %H:%M:%S")
endtime() {
  endtime=$(date "+%Y-%m-%d %H:%M:%S")
  duration=$(echo $((Sleep_time + $(date +%s -d "${endtime}") - $(date +%s -d "${starttime}"))) | awk '{t=split("60 秒 60 分 24 时 999 天",a);for(n=1;n<t;n+=2){if($1==0)break;s=$1%a[n]a[n+1]s;$1=int($1/a[n])}print s}')
  [[ ! -z $duration ]] && echo "- 耗时: $duration" || echo "- 秒刷！NB克拉斯！"
}
MODEL="$(my_grep_prop 'ro\.product\.model')"
[ -z "$MODEL" ] && MODEL="$(my_grep_prop 'ro\.product\.vendor\.model')"
MANUFACTURER="$(my_grep_prop 'ro\.product\.manufacturer')"
[ -z "$MANUFACTURER" ] && MANUFACTURER="$(my_grep_prop 'ro\.product\.vendor\.manufacturer')"
Permission_setting() {
  rm -rf $1
  touch $1
  chmod 000 $1
}
echo "# 信息
id=Small-Optimization
name=MIUI小优化模块
version=v5.1-($(getprop ro.product.device)-$(getprop ro.build.version.release)) Beta(元宵节)
versionCode=20210226
author=阿巴酱
description=“ 提高系统稳定性，优化系统流畅度？” 配置文件 >> [[ /sdcard/Android/MIUI小优化配置/ ]]
InstallationTime=$starttime" > $MODPATH/module.prop
[[ $MANUFACTURER != Xiaomi ]] && abort "- 此模块仅支持小米设备" || echo "- 设备支持此模块: $MODEL"
SO="/data/adb/modules/Small-Optimization"
Package_Name="com.miui.home
com.android.settings
com.miui.notification
com.android.systemui
com.miui.miwallpaper
com.xiaomi.misettings
com.miui.personalassistant"
echo "
***********************************************************
  ### v5.1 Beta(元宵节) 更新/测试内容 (2021-02-26)
  
  - (New) 相关信息加入MIUI版本显示
  - (New) 加入awk二进制（如果没有）
  - (New) 解决 相关信息.txt 中“耗电”为空的问题
  - 更改启动条件检测命令
  - 判断设备环境是否适合使用此模块 如果不适合将会当
  场EXIT去世并给出提示(模块介绍)
  - 加入正常运行次数记录
  - 解决v5.0-v5.1Beta不显示相关信息问题
  - 自动跳过模块冲突（已存在）内容
  - ..
  
 如果不需要这个模块了，请在Magisk Manager里面进行卸载。
***********************************************************
 "
if [[ ! -d $SO ]]; then
  echo "- 正在编译系统应用"
  for i in $Package_Name; do
  cmd package compile -m everything -f $i >/dev/null && echo "- $i 编译完成"
  done
  echo
else
  echo "- 已安装过小优化模块: 跳过重复执行everything编译"
  echo 
fi

mdnsd() {
if [[ -d /data/adb/modules/MIUI12ABajiangXiaoJingJian ]]; then
  echo "- 已安装小精简模块: 不执行移除mdnsd服务"
  echo 
  return
elif [[ -d /data/adb/modules/MIUIABajiangYCmdnsdFW ]]; then
  echo "- 已安装移除mdnsd服务的模块: 不执行移除mdnsd服务"
  echo 
  return
else
  [[ -e /system/bin/mdnsd ]] && mktouch $MODPATH/system/bin/mdnsd && echo "- 存在mdnsd，已创建模块文件"
  [[ -e /system/etc/init/mdnsd.rc ]] && mktouch $MODPATH/system/etc/init/mdnsd.rc && echo "- 存在mdnsd.rc，已创建模块文件"
  echo
fi
}
mdnsd

# 系统跟踪
if [[ ! -d /data/adb/modules/MIUI12ABajiangXiaoJingJian ]]; then
  mktouch $MODPATH/system/app/Traceur/.replace
  echo "- 移除系统跟踪"
  echo 
else
  echo "- 已安装小精简模块: 不执行移除系统跟踪"
  echo 
fi

# 删除桌面日志并禁止写入（来自雄氏老方）
if [[ -e /data/user_de/0/com.miui.home/cache/debug_log ]]; then
  Permission_setting /data/user_de/0/com.miui.home/cache/debug_log
  echo "- 已删除桌面日志并禁止写入"
  echo 
fi

# 删除不必要的网络日志（来自水龙）
if [[ -e /data/vendor/wlan_logs ]]; then
  Permission_setting /data/vendor/wlan_logs
  echo "- 已删除不必要的网络日志并禁止写入"
  echo 
fi

# cnss_diag
if [[ -e /system/vendor/bin/cnss_diag ]]; then
  mktouch $MODPATH/system/vendor/bin/cnss_diag
  echo "- 存在cnss_diag，已创建模块文件"
  echo 
fi

# 禁止mi-rcs 写日志（来自旧梦）
if [[ -e /data/media/0/JuphoonService ]];then
  Permission_setting /data/media/0/JuphoonService
  echo "- 已禁止mi-rcs写日志"
  echo 
fi

[[ ! -d /data/media/0/Android/MIUI小优化配置 ]] && mkdir -p /data/media/0/Android/MIUI小优化配置
cat $MODPATH/Script/Small-Optimization.conf > /data/media/0/Android/MIUI小优化配置/Small-Optimization.conf
if [[ -e $SO/Script/tmp/Script_Record.log ]]; then
  mkdir -p $MODPATH/Script/tmp/
  cat $SO/Script/tmp/Script_Record.log > $MODPATH/Script/tmp/Script_Record.log
fi
if [[ -e $SO/system/product/overlay/com.yuk.sqlite.apk ]]; then
  mkdir -p $MODPATH/system/product/overlay
  cp $SO/system/product/overlay/com.yuk.sqlite.apk $MODPATH/system/product/overlay
  echo "- 安装过sqlite提速: 已保留"
  echo 
fi
endtime
echo 
echo "- 安装完成！重启后请打开 /sdcard/Android/MIUI小优化配置/ 查看 ; 如果遇到修
改配置文件保存失败，请到 /data/media/0/Android/MIUI小优化配置/ 进行修改保存"
echo 
set_perm_recursive $MODPATH 0 0 0755 0644
set_perm $MODPATH/service.sh 0 0 777
set_perm $MODPATH/Script/StartUp 0 0 777
set_perm $MODPATH/Script/Discharge 0 0 777
set_perm $MODPATH/configurations 0 0 777
set_perm $MODPATH/MATERIAL/awk 0 0 755
