#!/system/bin/sh
MODDIR=${0%/*}
Permission_Setting() {
chmod 0644 $1
chown root:root $1
}
sdcard="/data/media/0/Android"
log="$sdcard/MIUI小优化配置/日志.log"
ANDROID=`getprop ro.build.version.release`
DEVICE=`getprop ro.product.device`
echo_Log() {
  echo "$(date "+%T") $@" >> $log
}
[[ -e /data/adb/modules/sdcardfs_y/remove ]] && rm -rf /data/adb/modules/sdcardfs_y/remove && echo_Log "sdcardfs取消移除"
[[ -d /data/adb/modules/sdcardfs ]] && return
[[ -d /data/adb/modules/sdcardfs_y ]] && return
if [[ -e /proc/filesystems && $(cat /proc/filesystems | awk '/sdcardfs/{print $2}') != sdcardfs ]]; then
  [[ ! -e $MODDIR/sdcardfs-no ]] && touch $MODDIR/sdcardfs-no
  echo_Log "内核不支持开启sdcardfs"
  return
fi
if [[ $ANDROID -lt 11 ]]; then
  [[ ! -e $MODDIR/sdcardfs-no ]] && touch $MODDIR/sdcardfs-no
  echo_Log "安卓 $ANDROID 无需开启sdcardfs"
  return
fi
if [[ $DEVICE == venus ]]; then
  [[ ! -e $MODDIR/sdcardfs-no ]] && touch $MODDIR/sdcardfs-no
  echo_Log "小米11不支持开启sdcardfs（会裂开）"
  return
fi
[[ ! -d /data/adb/modules/sdcardfs_y ]] && mkdir -p /data/adb/modules/sdcardfs_y
# 输出到module.prop
echo "id=sdcardfs_y
name=sdcardfs随机写入性能优化
version=$(date +"%Y%m%d")
versionCode=20210224
author=阿巴酱
description=你的设备: $DEVICE , 已开启SDcardFS 关闭FUSE 提升随机写入速度(↑25％) ; 由【MIUI小优化模块】自动创建: $(date "+%T")" > /data/adb/modules/sdcardfs_y/module.prop

# 输出到system.prop
echo 'persist.sys.fuse=false
persist.fuse_sdcard=false
persist.sys.fuse.default_fuse_enabled=false
persist.sys.fflag.override.settings_fuse=false
persist.device_config.storage_native_boot.fuse_enabled=false
ro.sys.sdcardfs=true' > /data/adb/modules/sdcardfs_y/system.prop

# 输出到service.sh
echo '#!/system/bin/sh
until [ $(getprop init.svc.bootanim) == "stopped" ]
do
  sleep 3
done
sleep 10
resetprop ro.sys.sdcardfs true
setprop ro.sys.sdcardfs true
setprop persist.sys.fuse false
setprop persist.fuse_sdcard false
setprop persist.sys.fuse.default_fuse_enabled false
setprop persist.sys.fflag.override.settings_fuse false
setprop persist.device_config.storage_native_boot.fuse_enabled false' > /data/adb/modules/sdcardfs_y/service.sh

# 输出到uninstall.sh
echo '#!/system/bin/sh
resetprop ro.sys.sdcardfs false
setprop ro.sys.sdcardfs false
setprop persist.sys.fuse true
setprop persist.fuse_sdcard true
setprop persist.sys.fuse.default_fuse_enabled true
setprop persist.sys.fflag.override.settings_fuse true
setprop persist.device_config.storage_native_boot.fuse_enabled true' > /data/adb/modules/sdcardfs_y/uninstall.sh
Permission_Setting /data/adb/modules/sdcardfs_y/service.sh >/dev/null
Permission_Setting /data/adb/modules/sdcardfs_y/uninstall.sh >/dev/null
echo_Log "开启sdcardfs成功 重启生效"

