#!/system/bin/sh

#1. 禁用高通的wlan_logs日志
#再开启WiFi之后会24小时占用磁盘带宽以及CPU生成写入日志, 
#且对我们无什么太大用处
#偶尔还会使待机时由于唤醒导致耗电严重

#解决办法:
#使用此命令: stop cnss_diag

#1-2. 禁用tcpdump日志工具
#* 跟cnss_diag同样且随同启动
#此工具主要用于网络抓包
#如果你不需要网络抓包场景也可以将其禁用


#解决办法:
#使用此命令: stop tcpdump

#清理日志文件命令: rm -rf /data/vendor/wlan_logs


#进程名称
proc="
cnss_diag
tcpdump
"

function kill_proc_(){
for file in `find /system /vendor /product /system_ext -iname "*.rc" 2> /dev/null ` ;do
	grep -l -q "$i" $file 2> /dev/null && {
		file=$(correctpath $file)
		mkdir -p $MODPATH${file%/*}
		cp -rf $file $MODPATH${file%/*}
		sed -i "s/.*"$1".*/#&/g" $MODPATH$file
	}
done
for file in `find /system /vendor /product /system_ext -iname "$1" 2> /dev/null ` ;do
		file=$(correctpath $file)
		mkdir -p $MODPATH${file%/*}
		touch $MODPATH$file && echo "－ 已创建${file##*/}"
done
}

echo -e "\n∞————————————————————————∞"
echo -e "\n－ ☞1. 禁用高通的wlan_logs日志☜"

#禁用进程
for i in $proc ;do
kill_proc_ "$i" 2 >/dev/null
done && echo -e "\n- 完成！\n" || echo "\n- 失败！\n"

#清理日志
logdir=/data/vendor/wlan_logs
test -e $logdir && { 
rm -rf $logdir 
touch $logdir
chmod 000 $logdir
}

#写入开机清理进程和日志的脚本
echo '
function key_killall (){
killall -9 "$1"
stop "$1"
}

key_killall "tcpdump"
key_killall "cnss_diag"


logdir=/data/vendor/wlan_logs
test -e $logdir && { 
rm -rf $logdir 
touch $logdir
chmod 000 $logdir
} ' > $MODPATH/mod/1WIFI.sh

echo -n [①禁用高通的wlan_logs日志] >>$TMPDIR/enable.log
