#!/system/bin/sh
MODDIR=${0%/*}

function get_focus() {
  m=`dumpsys window displays | grep mFocusedApp | grep -v "mFocusedApp=null"`
  m=${m#*=}
  m=${m#* }
  m=${m#* }
  m=${m%/*}
  m=${m%/*}
  echo $m
}
function boost_focus() {
  pgrep -f $1 | while read pid; do
    #renice -n -5 -p $pid
    echo $pid > /dev/cpuset/top-app/cgroup.procs
    echo $pid > /dev/stune/top-app/cgroup.procs
  done
}
function boost_ui() {
  pgrep -f $1 | while read pid; do
    #renice -n -20 -p $pid
    echo $pid > /dev/cpuset/top-app/cgroup.procs
    echo $pid > /dev/stune/top-app/cgroup.procs
  done
}
function boost_home() {
  pgrep -o $1 | while read pid; do
    #renice -n -20 -p $pid
    echo $pid > /dev/cpuset/top-app/cgroup.procs
    echo $pid > /dev/stune/top-app/cgroup.procs
  done
}
function limit() {
  pgrep -f $1 | while read pid; do
    #renice -n 0 -p $pid
    echo $pid > /dev/cpuset/background/cgroup.procs
    echo $pid > /dev/stune/background/cgroup.procs
  done
}
function kill_id() {
  pgrep -f $1 | while read pid; do
    kill -9 $pid
  done
}
function start_id() {
  monkey -p "$1" -c android.intent.category.LAUNCHER 1 &
}

count=0
arrow=0
m_last=`get_focus`
while true; do
#亮屏检测
screen=`dumpsys deviceidle get screen`
while [[ "$screen" = "false" ]]; do
  #echo "$(date +\"%H:%M:%S\") sleep" >> $MODDIR/debug.txt
  sleep 2
  screen=`dumpsys deviceidle get screen`
done
#及时启停
if [ -f "$MODDIR/disable" ]; then
  echo "$(date +\"%H:%M:%S\") disable" >> $MODDIR/debug.txt
  sleep 30
  continue
fi

m=`get_focus`
#不公平调度
if [[ "$m" == "$m_last" ]]; then
  sleep 1
  ((count++))
  if [[ "$count" == "10" ]]; then
    echo "$(date +\"%H:%M:%S\") limit ${list[*]}" >> $MODDIR/debug.txt
    for id in ${list[*]}; do
      if [[ "$id" != "$m" ]]; then
        limit $id
      fi
    done
    unset list
    arrow=0
  fi
else
  count=0
  if [[ "$m" != "com.meizu.flyme.launcher" ]]; then
    echo "$(date +\"%H:%M:%S\") boost $m" >> $MODDIR/debug.txt
    #boost_focus $m
  fi
  if [[ "$m_last" != "com.meizu.flyme.launcher" ]]; then
    if echo "${list[*]}" | grep -wq "$m_last"; then
      #echo "$(date +\"%H:%M:%S\") found" >> $MODDIR/debug.txt
      sleep 0.1
    else
      list[$arrow]="$m_last"
      #echo "$(date +\"%H:%M:%S\") $arrow $m_last" >> $MODDIR/debug.txt
      ((arrow++))
      sleep 0.1
    fi
  fi
  m_last=$m
fi

done