#!/bin/env sh
# 请不要硬编码/magisk/modname/...;相反，请使用$MODDIR/...
# 这将使您的脚本兼容，即使Magisk以后改变挂载点
MODDIR=${0%/*}

var_device="`getprop ro.product.vendor.device`"
var_id="`getprop ro.build.display.id`"
var_type="`getprop ro.oplus.image.my_product.type`"
var_version="`getprop ro.build.version.release`"
OP="`getprop ro.build.version.release`"

MTeamS_COS_Strengthen=/data/adb/modules/MTeamS_COS_Strengthen

function get_dns1() {
getprop | grep dns1
}

function get_dns2() {
getprop | grep dns2
}

function get_server() {
settings list global | grep dns_server
}

DNS1=$(get_dns1)
DNS2=$(get_dns2)
SERVER=$(get_server)


# show Message
name="name=ColorOS$OP优化起飞增强附列模块"
title="description=ColorOS$OP起飞增强附列模块配置： "
endname1=" ✲文件验证通过:[build] "
endname2=" ✲设备代号通过:[$var_device] "
endname3=" ✲系统版本通过:[$var_id] "
endname4=" ✲系统代号通过:[$var_type] "
endname5=" ✲安卓版本通过:[$var_version] "
endname6=" ✲设备代号:[$var_device] "
endname7=""
model1=""
model2=""
model3=""
model4=""
model5=""
model6=""
model7=""
model8=""
model9=""
model10=""
model11=""
model12=""
model13=""
model14=""
model15=""
model16=""
model17=""

if [ -f "/data/adb/modules/MTeamS_COS_Strengthen/module.prop" ];then
if [ -f "$MTeamS_COS_Strengthen/HighProcess.rc" ];then
  model1="✲处理高费电进程模块；"
fi

if [ -e "$MTeamS_COS_Strengthen/SurfaceFlinger" ];then
if [ -f "$MTeamS_COS_Strengthen/SurfaceFlinger/MTeams" ];then
  model2="✲ColorOS自动识别档位全局高刷：已运行；"
  else
  model2="✲ColorOS自动识别档位全局高刷：未运行；"
fi
fi

if [ -f "$MTeamS_COS_Strengthen/MTeam_DNS.sh" ];then
  model3="✲DNS优化：已运行；"
  model4="✲默认腾讯DNS、支持自定义、配置文件地址：(内置存储Android下的Dns.conf) "
  model5=" ✲本地DNS$DNS1 $DNS2 ✲服务器$SERVER"
fi
else
model17="✲状态：已失效"
fi

description=$title$model1$model2$model3$model4$model5$model6$model7$model8$model9$model10$model11$model12$model13$model14$model15$model16$model17$endname7

sed -i "s/name=.*$/$name/g" $MODDIR/module.prop
sed -i "s/description=.*$/$description/g" $MODDIR/module.prop
