# 安装时显示的模块名称
mod_name="ColorOS12系统调整"
# 模块介绍
mod_install_desc="磁盘优化、IO优化调整、降低了读写缓存，对于目前的UFS3闪存来说，IO性能足够，并不需要太多内存缓存来提高性能"
# 安装时显示的提示
mod_install_info="是否安装[$mod_name]"
# 按下[音量+]选择的功能提示
mod_select_yes_text="安装$mod_name"
# 按下[音量+]后加入module.prop的内容
mod_select_yes_desc="[$mod_name]"
# 按下[音量-]选择的功能提示
mod_select_no_text="不安装$mod_name"
# 按下[音量+]时执行的函数
# 如果不需要，请保留函数结构和return 0   
mod_install_yes()
{

cpu="`getprop ro.soc.manufacturer`"
if [ $cpu = Qualcomm ];then
echo "      检测到高通设备安装模块IOP..."
function correctpath() {
	case $(echo "$1") in
	/system*)
		echo "$1"
	;;
	/*)
		echo "/system"$1""
	;;
	esac
}

function Disable_old_value() {
	local file="$1"
	for value in $(cat $MODPATH/system.prop | sed 's|\=.*||g;/^\#/d;/^[[:space:]]*$/d' )
	do
		sed -i "s#.*<.*Prop.*Name.*=\"$value\".*Value=\".*\".*/>.*#\<\!\-\- & \-\-\>#g" "$file"
	done
}

function mk_pfer_file() {
	find /system /product /vendor /system_ext -iname "perfconfigstore.xml" -type f 2> /dev/null | while read file ;do
	target=$(correctpath "$file" )
	mkdir -p "$MODPATH${target%/*}"
	cp -rf "$file" "$MODPATH$target"
	Disable_old_value "$MODPATH$target"
done || echo "      不存在perfconfigstore.xml文件！"
}

qualcomm_prop=`getprop | egrep -w "qualcomm|qti" | wc -l`
qualcomm_package=`pm list package -s | egrep -w "qualcomm|qti" | wc -l`
if test $qualcomm_prop -lt 1 -a $qualcomm_package -lt 1 ;then 
	abort "      非高通骁龙设备！"
else 
	mk_pfer_file
fi

# 输出system.prop
echo "
# 禁用不必要的转储
persist.vendor.ssr.enable_ramdumps=0
dalvik.vm.dex2oat-minidebuginfo=false
dalvik.vm.minidebuginfo=false
dalvik.vm.dex2oat64.enabled=true
persist.sys.force_sw_gles=0
persist.sys.log.lfeh=false
# IOP优化
vendor.iop.enable_iop=1
vendor.iop.enable_uxe=1
vendor.iop.enable_prefetch_ofr=false
vendor.enable.prefetch=false
vendor.perf.iop_v3.enable=true
vendor.perf.iop_v3.enable.debug=false
vendor.perf.gestureflingboost.enable=true
" >> $MODPATH/system.prop
else
echo "      检测到非高通设备跳过安装IOP..."
fi

touch $MODPATH/Build/MTeam_BOOST

    return 0
}
mod_install_no()
{

    return 0
}