#!/bin/env sh
MODDIR=${0%/*}
module=/data/adb/modules/MTeamS_COS_Strengthen/module.prop
conf="/data/adb/modules/MTeamS_COS_Strengthen/Groups/freezer.conf"
model=$(sed '/^自定义模式=/!d;s/.*=//' $conf)
processrate=$(sed '/^进程CPU用率=/!d;s/.*=//' $conf)
freezer=$(mount | grep cgroup | grep freezer | cut -d ' ' -f3 | tail -n 1)
cpuctl=$(mount | grep cgroup | grep cpuctl | cut -d ' ' -f3 | tail -n 1)
sysfs="/sys/fs/cgroup"
#代码有点草率了没简化
miancpuctl() {
	mkdir $cpuctl/MTeam
	if [[ -d "$cpuctl/MTeam" ]]; then
		sed -i "s/状态：.*/状态：cpuctl成功/g" $module
		while read document; do
			process=$(pidof "$document" | cut -d ' ' -f1)
			if [[ $process != 0 ]]; then
				echo $process >>$cpuctl/MTeam/cgroup.procs
			fi
		done <$conf
		echo $processrate >$cpuctl/MTeam/cpu.rt_period_us
		echo 0.01 >$cpuctl/MTeam/cpu.uclamp.max
		echo 0.00 >$cpuctl/MTeam/cpu.uclamp.min
		echo 0 >$cpuctl/MTeam/cpu.shares
	else
		sed -i "s/状态：.*/状态：cpuctl失败/g" $module
		exit
	fi
}
mianfreezer() {
	if [[ -d "$sysfs" ]]; then
		if [[ $(mount | grep $sysfs) == "" ]]; then
			mount -t tmpfs HCcgroup /sys/fs/cgroup
		fi
		if [[ ! -d "$sysfs/freezer" ]]; then
			mkdir $sysfs/freezer
			mount -t cgroup -o freezer HCfreezer $sysfs/freezer
		fi
	fi
	freezer=$(mount | grep cgroup | grep freezer | cut -d ' ' -f3 | tail -n 1)
	mkdir $freezer/MTeam
	if [[ -d "$freezer/MTeam" ]]; then
		sed -i "s/状态：.*/状态：freezer成功/g" $module
		while read document; do
			process=$(pidof "$document" | cut -d ' ' -f1)
			if [[ $process != 0 ]]; then
				echo $process >>$freezer/MTeam/cgroup.procs
			fi
		done <$conf
		echo FROZEN >$freezer/MTeam/freezer.state
	else
		sed -i "s/状态：.*/状态：freezer失败/g" $module
		exit
	fi
}
mianfreezercpuctl() {
	if [[ -d "$sysfs" ]]; then
		if [[ $(mount | grep $sysfs) == "" ]]; then
			mount -t tmpfs HCcgroup /sys/fs/cgroup
		fi
		if [[ ! -d "$sysfs/freezer" ]]; then
			mkdir $sysfs/freezer
			mount -t cgroup -o freezer HCfreezer $sysfs/freezer
		fi
	fi
	freezer=$(mount | grep cgroup | grep freezer | cut -d ' ' -f3 | tail -n 1)
	mkdir $freezer/MTeam
	if [[ -d "$freezer/MTeam" ]]; then
		sed -i "s/状态：.*/状态：默认freezer成功/g" $module
		while read document; do
			process=$(pidof "$document" | cut -d ' ' -f1)
			if [[ $process != 0 ]]; then
				echo $process >>$freezer/MTeam/cgroup.procs
			fi
		done <$conf
		echo FROZEN >$freezer/MTeam/freezer.state
	else
		mkdir $cpuctl/MTeam
		if [[ -d "$cpuctl/MTeam" ]]; then
			sed -i "s/状态：.*/状态：默认cpuctl成功/g" $module
			while read document; do
				process=$(pidof "$document" | cut -d ' ' -f1)
				if [[ $process != 0 ]]; then
					echo $process >>$cpuctl/MTeam/cgroup.procs
				fi
			done <$conf
			echo $processrate >$cpuctl/MTeam/cpu.rt_period_us
			echo 0.01 >$cpuctl/MTeam/cpu.uclamp.max
			echo 0.00 >$cpuctl/MTeam/cpu.uclamp.min
			echo 0 >$cpuctl/MTeam/cpu.shares
		else
			sed -i "s/状态：.*/状态：默认freezer和cpuctl都失败/g" $module
			exit
		fi
	fi
}
case $model in
模式1 | 1)
	mianfreezercpuctl
	;;
模式2 | 2)
	mianfreezer
	;;
模式3 | 3)
	miancpuctl
	;;
*)
	sed -i "s/状态：.*/状态：配置文件自定义模式出错/g" $module
	exit 1
	;;
esac