#!/bin/sh
MODPATH=/data/adb/modules_update/MTeamS_COS_Strengthen
export PATH="$PATH:$(magisk --path)/.magisk/busybox"

if [ $API -le 30 ]; then #cos11
	ETP=/my_product/etc/temperature_profile;
	ETSC=/my_product/etc/ThermalServiceConfig;
	ADFRC=oplus_adfr_config;
	DPL=oppo_display_perf_list;
else # cos12~13
	ETP=/odm/etc/temperature_profile;
	ETSC=/odm/etc/ThermalServiceConfig;
	ADFRC=oplus_vrr_config;
	DPL=multimedia_display_perf_list;
fi;
mount --bind /data/adb/modules_update/MTeamS_COS_Strengthen/key/Refresh.sh /my_product/etc/refresh_rate_config.xml

# 屏幕刷新率重点应用名单
src_rrc=/my_product/etc/refresh_rate_config.xml

# 动态刷新率(adfr)  221005 only for realme
#src_ovc=/my_product/etc/oplus_vrr_config.json

# 视频播放器帧率控制
#src_mdpl=/my_product/vendor/etc/multimedia_display_perf_list.xml

# 动态刷新率
src_ovc=/my_product/etc/${ADFRC}.json

# 视频播放器帧率控制
src_mdpl=/my_product/vendor/etc/${DPL}.xml

echo2n() { echo -e "\n\nNo. $sn";sn=$(($sn+1));}

pfds=$MODPATH/post-fs-data.sh
mountPfd() {
	pfdDir=$(dirname "$1" | sed -e 's/^\/vendor\//\/system\/vendor\//' -e 's/^\/product\//\/system\/product\//' -e 's/^\/system_ext\//\/system\/system_ext\//')
	[ -d "$MODPATH$pfdDir" ] || mkdir -p "$MODPATH$pfdDir"
	# echo "将复制 $1 到模块后修改"
	cp -rf "$1" "$MODPATH$pfdDir"
	pfd="$MODPATH$pfdDir/${1##*/}"
	if [ -f "$pfd" ];then echo "mount --bind \$MODDIR$pfdDir/${1##*/} $1" >>$pfds;else abort " ✘ 模块目录下竟然没有需编辑的 $pfd 文件，请联系开发者修复！";fi
}

blMv() {
	# 删除注释
	# sed -i '/^<\!--/,/-->$/c''' $pfd ;# 会错误地删除部分非注释
	sed -i 's/[[:space:]]*<\!--.*-->[[:space:]]*//g' $pfd
	# 删除空行
	sed -i '/^[[:space:]]*$/d' $pfd
}

chkFUN() { if [ -z $1 ];then echo "未定义 $2 文件";else $3 "$1" "$2文件";fi;}

FUN_rcc(){
if [ -f $1 ];then mountPfd $1
echo2n
	echo "－开始修改$2：$1"
	sed -i 's/rateId=\"[0-9]-[0-9]-[0-9]-[0-9]/rateId=\"3-1-2-3/g' $pfd && echo "已全局改刷新率模式为 3-1-2-3"
	sed -i 's/enableRateOverride="true/enableRateOverride="false/g' $pfd && echo "surfaceview，texture场景不降"
	sed -i 's/disableViewOverride="true/disableViewOverride="false/g' $pfd && echo "已关闭disableViewOverride"
	sed -i 's/inputMethodLowRate="true/inputMethodLowRate="false/g' $pfd && echo "已关闭输入法降帧"
	blMv
	echo -e "修改$2完成\n注意：系统设置刷新率仍然生效"
else echo " ✘ 不存在$2：$1" >&2;fi
}
chkFUN $src_rrc "屏幕刷新率重点应用名单" FUN_rcc
umount /my_product/etc/refresh_rate_config.xml

#FUN_ovc(){
#if [ -f $1 ];then mountPfd $1
#echo2n
#	echo "－开始修改$2：$1"
#	sed -i '/\"blacklist\"/,/[\s\S]*\s*\]/d' $pfd && echo "已删除黑名单"
#	sed -i '/\"sw_whitelist\"/,/[\s\S]*\s*\]/d' $pfd && echo "已删除黑名单"
#	sed -i '/\"sw_negligible_overlay\"/,/[\s\S]*\s*\]/d' $pfd && echo "已删除黑名单"
#	sed -i -e '/"timeout": [0-9]*,/d' -e '/"hw_brightness_limit": [0-9]*,/d' -e '/"hw_gray": true,/d' -e '/"hw_gray_threshold": [0-9]*,/d' -e '/"hw_gray_percent": [0-9]*,/d' $pfd && echo "已删除多余内容"
#	echo "修改$2完成"
#else echo " ✘ 不存在$2：$1" >&2;fi
#}
#chkFUN $src_ovc "动态刷新率(adfr) " FUN_ovc

FUN_mdpl(){
if [ -f $1 ];then mountPfd $1
echo2n
	echo "－开始修改$2：$1"
	sed -i -e '/<fps>/d' -e '/<vsync>/d' $pfd && echo "已删除锁帧、垂直同步设置"
	blMv
	echo -e "修改$2完成\n设置120hz时，播放视频可120hz"
else echo " ✘ 不存在$2：$1" >&2;fi
}
chkFUN $src_mdpl "视频播放器帧率控制" FUN_mdpl
