#!/bin/env sh
MODDIR=${0%/*}

sleep 90
MTeam=`cat "/data/media/0/Android/Dns.conf" | grep 'MTeam=' | awk -F '=' '{print $2}'`
MTeam_IPTCP=`cat "/data/media/0/Android/Dns.conf" | grep 'MTeam_IPTCP=' | awk -F '=' '{print $2}'`
MTeam_IPUDP=`cat "/data/media/0/Android/Dns.conf" | grep 'MTeam_IPUDP=' | awk -F '=' '{print $2}'`
MTeam_DNS1=`cat "/data/media/0/Android/Dns.conf" | grep 'MTeam_DNS1=' | awk -F '=' '{print $2}'`
MTeam_DNS2=`cat "/data/media/0/Android/Dns.conf" | grep 'MTeam_DNS2=' | awk -F '=' '{print $2}'`
MTeam_SERVER=`cat "/data/media/0/Android/Dns.conf" | grep 'MTeam_SERVER=' | awk -F '=' '{print $2}'`


#重定向到指定DNS
iptables -t nat -F OUTPUT
iptables -t nat -I OUTPUT -p tcp --dport $MTeam -j DNAT --to-destination $MTeam_IPTCP:$MTeam
iptables -t nat -I OUTPUT -p udp --dport $MTeam -j DNAT --to-destination $MTeam_IPUDP:$MTeam

#设置Tencent DNS为本地DNS
setprop net.dns1 $MTeam_DNS1
setprop net.dns2 $MTeam_DNS2


#设置腾讯dns服务器
settings put global dns_server $MTeam_SERVER

ip route | while read r; do
ip route change $r initcwnd 20;
done

ip route | while read r; do
ip route change $r initrwnd 20;
done
