#!/bin/env sh
MODPATH=${0%/*}
function get_on_list() {
	local file=$MODPATH/conf/process_killed_screen_on.conf
	cat "${file}" | sed '/^#/d;/^[[:space:]]*$/d'
}

function get_off_list() {
	local file=$MODPATH/conf/process_killed_screen_off.conf
	cat "${file}" | sed '/^#/d;/^[[:space:]]*$/d'
}

function top_app() {
	app=$(dumpsys window | grep mCurrentFocus | egrep -o "[^ ]*/[^\\}]+" | cut -d '/' -f1)
	echo "$app"
}

function kill_on_process() {
	for i in $(get_on_list); do
		pgrep -f "$i" | while read PID; do
			[[ "$i" == *"$(top_app)"* ]] && break
            kill -9 "$PID" || kill -19 "$PID"
		done
	done
}

function kill_off_process() {
	for i in $(get_off_list); do
		pgrep -f "$i" | while read PID; do
			[[ "$i" == *"$(top_app)"* ]] && break
			kill -9 "$PID" || kill -19 "$PID"
		done
	done
}

locked_status= dumpsys window policy | grep mIsShowing | sed 's/ //g' | sed 's/mIsShowing=//g'
if [ $locked_status =="false" ];then
	kill_on_process
else
	kill_off_process
fi