#!/system/bin/sh
#
# Copyright (C) 2021-2022 Matt Yang
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

# Runonce after boot, to speed up the transition of power modes in powercfg

MODDIR=${0%/*}

# $1:value $2:filepaths
lock_val() {
    for p in $2; do
        if [ -f "$p" ]; then
            chown root:root "$p"
            chmod 0666 "$p"
            echo "$1" >"$p"
            chmod 0444 "$p"
        fi
    done
}

# $1:value $2:filepaths
mutate() {
    for p in $2; do
        if [ -f "$p" ]; then
            chmod 0666 "$p"
            echo "$1" >"$p"
        fi
    done
}

wait_until_login() {
    # in case of /data encryption is disabled
    while [ "$(getprop sys.boot_completed)" != "1" ]; do
        sleep 1
    done

    # no need to start before the user unlocks the screen
    local test_file="/sdcard/Android/.ASOUL_PERMISSION_TEST"
    true >"$test_file"
    while [ ! -f "$test_file" ]; do
        true > "$test_file"
        sleep 1
    done
    rm "$test_file"
}

# $1:"min_cpus" $2:"0:4 4:3 7:1"
set_corectl_param() {
    local key
    local val
    for kv in $2; do
        key=${kv%:*}
        val=${kv#*:}
        lock_val "$val" /sys/devices/system/cpu/cpu$key/core_ctl/$1
    done
}

disable_hotplug() {
    # Exynos hotplug
    mutate "0" /sys/power/cpuhotplug/enabled
    mutate "0" /sys/devices/system/cpu/cpuhotplug/enabled

    # turn off msm_thermal
    lock_val "0" /sys/module/msm_thermal/core_control/enabled
    lock_val "N" /sys/module/msm_thermal/parameters/enabled

    # 3rd
    lock_val "0" /sys/kernel/intelli_plug/intelli_plug_active
    lock_val "0" /sys/module/blu_plug/parameters/enabled
    lock_val "0" /sys/devices/virtual/misc/mako_hotplug_control/enabled
    lock_val "0" /sys/module/autosmp/parameters/enabled
    lock_val "0" /sys/kernel/zen_decision/enabled

    # stop sched core_ctl
    set_corectl_param "enable" "0:0 2:0 4:0 6:0 7:0"

    # bring all cores online
    for i in 0 1 2 3 4 5 6 7 8 9; do
        lock_val "1" /sys/devices/system/cpu/cpu$i/online
    done
}

disable_userspace_boost() {
    # xiaomi vip-task scheduler override
    if [ -d /dev/migt ]; then
        chmod 0000 /dev/migt
    fi
    if [ -d /sys/module/migt ]; then
        for f in /sys/module/migt/parameters/*; do
            chmod 0000 $f
        done
    fi

    # work with AsoulOpt
    lock_val "0" "/sys/module/mtk_fpsgo/parameters/boost_affinity*"
    lock_val "0" "/sys/module/fbt_cpu/parameters/boost_affinity*"
    lock_val "9999000" "/sys/kernel/fpsgo/fbt/limit_*"
    lock_val "0" /sys/kernel/fpsgo/fbt/switch_idleprefer
    lock_val "0" /sys/kernel/fpsgo/minitop/enable
    lock_val "1" /proc/perfmgr/syslimiter/syslimiter_force_disable
    lock_val "0" /sys/module/mtk_core_ctl/parameters/policy_enable
    lock_val "90" /sys/kernel/fpsgo/fbt/thrm_temp_th
    lock_val "-1" /sys/kernel/fpsgo/fbt/thrm_limit_cpu
    lock_val "-1" /sys/kernel/fpsgo/fbt/thrm_sub_cpu
}

disable_userspace_thermal() {
    # yes, let it respawn
    if [ -f /vendor/bin/mi_thermald ]; then
        killall mi_thermald
    fi
    # prohibit mi_thermald use cpu thermal interface
    for i in 0 2 4 6 7; do
        local maxfreq="$(cat /sys/devices/system/cpu/cpu$i/cpufreq/cpuinfo_max_freq)"
        [ "$maxfreq" -gt "0" ] && lock_val "cpu$i $maxfreq" /sys/devices/virtual/thermal/thermal_message/cpu_limits
    done
}

restart_userspace_thermal() {
    # yes, let it respawn
    if [ -f /vendor/bin/mi_thermald ]; then
        killall mi_thermald
    fi
}

wait_until_login

disable_hotplug
disable_userspace_thermal
restart_userspace_thermal
disable_userspace_boost

pkill AsoulOpt
nohup $MODDIR/AsoulOpt > /dev/null 2>&1 &
