#!/system/bin/sh
#老铁麒麟调度    Fe Kirin control
#适用于麒麟970设备    Suitable for Kirin970 device
#禁止二次修改！    DON'T second modification！
#允许您使用此项目对您的公开ROM/软件进行非盈利和商业行为的内嵌，但是需要您在项目、插件或ROM此类的介绍的位置标注作者和名称:
#
#原作者：酷安@Cirrest
#原项目名称：Fe Kirin control
#
#Embed is allowed, but the information below MUST be notated at the beginning of your intro:
#
#Original Author：Coolapk @Cirrest
#Original Project：Fe Kirin control

#语法定义
BUSYBOX="/data/adb/magisk/busybox"
IO_RABDOM="/sys/block/mmcblk0/queue/add_random"
IO_HELP="/sys/block/mmcblk0/queue/nomerges"
IO_STATS="/sys/block/mmcblk0/queue/iostats"
LMK_DEBUG="/sys/module/lowmemorykiller/parameters/debug_level"
LITTLE_INTERACTIVE="/sys/devices/system/cpu/cpu0/cpufreq/interactive"
BIG_INTERACTIVE="/sys/devices/system/cpu/cpu4/cpufreq/interactive"
GPU_MIN="/sys/devices/platform/e82c0000.mali/devfreq/gpufreq/min_freq"
GPU_MAX="/sys/devices/platform/e82c0000.mali/devfreq/gpufreq/max_freq"
LITTLE_CPUFREQ="/sys/devices/system/cpu/cpu0/cpufreq"
BIG_CPUFREQ="/sys/devices/system/cpu/cpu4/cpufreq"
LITTLE_CPUMAX="/sys/devices/system/cpu/cpu0/cpufreq/scaling_max_freq"
LITTLE_CPUMIN="/sys/devices/system/cpu/cpu0/cpufreq/scaling_min_freq"
BIG_CPUMAX="/sys/devices/system/cpu/cpu4/cpufreq/scaling_max_freq"
BIG_CPUMIN="/sys/devices/system/cpu/cpu4/cpufreq/scaling_min_freq"
init_kirin970_rc="/vendor/etc/init/hw/init.kirin970.rc"

#(弃用)关闭SELinux	
#setenforce 0
# INTERACTIVE Timer
function set_param_little() 
{
	echo ${2} > ${LITTLE_INTERACTIVE}/${1}
}

function set_param_big() 
{
	echo ${2} > ${BIG_INTERACTIVE}/${1}
}

function print_param() 
{
	print_value "LITTLE: ${1}" ${LITTLE_INTERACTIVE}/${1}
	print_value "big: ${1}" ${BIG_INTERACTIVE}/${1}
}

function unify_environment() 
{

	#调速器lock
	lock_value 0 /sys/power/cpuhotplug/enabled
	lock_value 0 /sys/devices/system/cpu/cpuhotplug/enabled
	lock_value 1 /sys/devices/system/cpu/cpu4/online
	lock_value 1 /sys/devices/system/cpu/cpu5/online
	lock_value 1 /sys/devices/system/cpu/cpu6/online
	lock_value 1 /sys/devices/system/cpu/cpu7/online
	lock_value "interactive" ${LITTLE_CPUFREQ}/scaling_governor
	lock_value "interactive" ${BIG_CPUFREQ}/scaling_governor
}

function runonce_custom()
{
	#CPUSET核心分配
	set_value 2-3 /dev/cpuset/background/cpus
	set_value 0-3 /dev/cpuset/system-background/cpus
	set_value 0-4 /dev/cpuset/foreground/cpus
	set_value 0-7 /dev/cpuset/top-app/cpus

	#基于HMP的响应时间参数
	lock_value 256 /sys/kernel/hmp/down_threshold
	lock_value 640 /sys/kernel/hmp/up_threshold
	lock_value 0 /sys/kernel/hmp/boost
}
	
#INTERACTIVE调度器
function before_modify()
{
	chown 0.0 ${LITTLE_INTERACTIVE}/*
	chmod 0666 ${LITTLE_INTERACTIVE}/*
	lock_value 480000 ${LITTLE_CPUFREQ}/scaling_min_freq

	set_value 1 /sys/devices/system/cpu/cpu4/online
	chown 0.0 ${BIG_INTERACTIVE}/*
	chmod 0666 ${BIG_INTERACTIVE}/*
	lock_value 680000 ${BIG_CPUFREQ}/scaling_min_freq
}

	#权限设置
function after_modify()
{
	chmod 0444 ${LITTLE_INTERACTIVE}/*
	chmod 0444 ${BIG_INTERACTIVE}/*
	verify_param
}

#挖坑
function powersave_custom()
{
	:
}

function balance_custom()
{
	:
}

function performance_custom()
{
	:
}

function fast_custom()
{
	:
}


function set_value() 
{
	if [ -f $2 ]; then
		echo $1 > $2
	fi
}

function lock_value() 
{
	if [ -f $2 ]; then
		chmod 0666 $2
		echo $1 > $2
		chmod 0444 $2
	fi
}

#	IO
#	$1:io-scheduler 
#	$2:block-path
function set_io() 
{
	if [ -f $2/queue/scheduler ]; then
		if [ `grep -c $1 $2/queue/scheduler` = 1 ]; then
			echo $1 > $2/queue/scheduler
			echo 512 > $2/queue/read_ahead_kb
			lock_value 0 $2/queue/iostats
			lock_value 256 $2/queue/nr_requests
			lock_value 0 $2/queue/iosched/slice_idle
		fi
	fi
}

function print_value() 
{
	if [ -f $2 ]; then
		echo $1
		cat $2
	fi
}

function set_init() 
{
	if [ -f $2 ]; then
		#调度调用
		chmod 0666 $2
		print_config \system\etc\xml\config\970_socsys_config.xml
		print_config \system\product\etc\hwpg\*.xml
		set_param_init \system\etc\init\etc_print_config.rc
		boot="\system\etc\serviceso\sysboot.so"
		boot agc T
		echo $1 > $2
		cat $2
		chmod 0444 $2
	fi
}
#VERIFY_INTERACTIVE
function verify_param() 
{
	expected_target=${LITTLE_INTERACTIVE}/target_loads
	if [ "$action" = "powersave" ]; then
		expected_value="80 980000:60 1180000:87 1380000:70 1480000:98"
	elif [ "$action" = "balance" ]; then
		expected_value="80 980000:61 1180000:88 1380000:70 1480000:96"
	elif [ "$action" = "performance" ]; then
		expected_value="80 980000:63 1180000:76 1480000:96"
	elif [ "$action" = "fast" ]; then
		expected_value="80 1780000:90"
	fi
	if [ "`cat ${expected_target}`" = "${expected_value}" ]; then
		echo "${action} OK"
	else
		echo "${action} FAIL"
	fi
}

action=$1
if [ ! -n "$action" ]; then
    action="balance"
fi

#SCENE
if [ ! -f /dev/.Fe_Kirin970 ]; then
	#触发
	touch /dev/.Fe_Kirin970
	runonce_custom
	#RUN
    ${BUSYBOX} fstrim /data 2>/dev/null
    ${BUSYBOX} fstrim /cache 2>/dev/null
    ${BUSYBOX} fstrim /system 2>/dev/null
    ${BUSYBOX} fstrim /userdata 2>/dev/null
    sm fstrim 2>/dev/null
	#i/o控制器设定
	set_io cfq /sys/block/mmcblk0
	set_io cfq /sys/block/sda
	#增加I/O随机性
    echo 1 > ${IO_RABDOM}
    #禁用LMK调试日志
    echo 0 > ${LMK_DEBUG}
    #禁用I/O调试帮助
    echo 0 > ${IO_HELP}
    #禁用I/O调度统计
    echo 0 > ${IO_STATS}

	#Timer boost
	set_param_little timer_rate 20000
	set_param_little timer_slack 180000
	set_param_little boost 0
	set_param_little boostpulse_duration 0
	set_param_big timer_rate 20000
	set_param_big timer_slack 180000
	set_param_big boost 0
	set_param_big boostpulse_duration 0
	set_init run 1
	#hwinit
	echo "on property:ro.vendor.user_hota_update=1
		  write /sys/devices/system/cpu/cpu0/cpufreq/scaling_max_freq 1556000
		  write /sys/devices/system/cpu/cpu4/cpufreq/scaling_max_freq 1652000
		 "> ${init_kirin970_rc}
fi

#省电
if [ "$action" = "powersave" ]; then
	powersave_custom
	set_param_little above_hispeed_delay "18000 1380000:38000 1480000:98000"
	set_param_little hispeed_freq 1180000
	set_param_little go_hispeed_load 98
	set_param_little target_loads "80 980000:60 1180000:87 1380000:70 1480000:98"
	set_param_little min_sample_time 18000
	echo "1690000"> ${LITTLE_CPUMAX}
	echo "509000"> ${LITTLE_CPUMIN}
	set_param_big above_hispeed_delay "18000 1580000:98000 1780000:138000"
	set_param_big hispeed_freq 1280000
	set_param_big go_hispeed_load 98
	set_param_big target_loads "80 1280000:98 1480000:91 1580000:98"
	set_param_big min_sample_time 18000
	echo "1863000"> ${BIG_CPUMAX}
	echo "682000"> ${BIG_CPUMIN}
	echo "103750000"> ${GPU_MIN}
    echo "415000000"> ${GPU_MAX}
fi

#平衡
if [ "$action" = "balance" ]; then
	balance_custom
	set_param_little above_hispeed_delay "18000 1480000:38000 1680000:98000"
	set_param_little hispeed_freq 1180000
	set_param_little go_hispeed_load 97
	set_param_little target_loads "80 980000:61 1180000:88 1380000:70 1480000:96"
	set_param_little min_sample_time 38000
	echo "1844000"> ${LITTLE_CPUMAX}
	echo "509000"> ${LITTLE_CPUMIN}
	set_param_big above_hispeed_delay "18000 1580000:98000 1780000:138000"
	set_param_big hispeed_freq 1280000
	set_param_big go_hispeed_load 94
	set_param_big target_loads "80 980000:72 1280000:77 1580000:98"
	set_param_big min_sample_time 18000
	echo "2362000"> ${BIG_CPUMAX}
	echo "682000"> ${BIG_CPUMIN}
	echo "103750000"> ${GPU_MIN}
    echo "767000000"> ${GPU_MAX}
fi

#性能
if [ "$action" = "performance" ]; then
	performance_custom
	set_param_little above_hispeed_delay "18000 1680000:38000"
	set_param_little hispeed_freq 1180000
	set_param_little go_hispeed_load 98
	set_param_little target_loads "80 980000:63 1180000:76 1480000:96"
	set_param_little min_sample_time 78000
	echo "1844000"> ${LITTLE_CPUMAX}
	echo "1210000"> ${LITTLE_CPUMIN}
	set_param_big above_hispeed_delay "18000 1580000:98000 1780000:38000"
	set_param_big hispeed_freq 1480000
	set_param_big go_hispeed_load 86
	set_param_big target_loads "80 980000:57 1280000:70 1480000:65 1580000:98"
	set_param_big min_sample_time 18000
	echo "2362000"> ${BIG_CPUMAX}
	echo "682000"> ${BIG_CPUMIN}
	echo "237143000"> ${GPU_MIN}
    echo "767000000"> ${GPU_MAX}
fi

#极速
if [ "$action" = "fast" ]; then
	fast_custom
	lock_value 1480000 ${LITTLE_CPUFREQ}/scaling_min_freq
	set_param_little above_hispeed_delay "18000 1680000:198000"
	set_param_little hispeed_freq 1480000
	set_param_little target_loads "80 1780000:90"
	set_param_little min_sample_time 38000
	echo "1844000"> ${LITTLE_CPUMAX}
	echo "1402000"> ${LITTLE_CPUMIN}
	lock_value 1280000 ${BIG_CPUFREQ}/scaling_min_freq
	set_param_big above_hispeed_delay "18000 1780000:198000"
	set_param_big hispeed_freq 1280000
	set_param_big target_loads "80 1980000:90"
	set_param_big min_sample_time 38000
	echo "2362000"> ${BIG_CPUMAX}
	echo "1210000"> ${BIG_CPUMIN}
	echo "415000000"> ${GPU_MIN}
    echo "767000000"> ${GPU_MAX}
fi

after_modify
#by Cirrest
#逐渐弃用此脚本，转移至Services服务
#Last Build:2022/09/25
exit 0
