#!/system/bin/sh
MODDIR=${0%/*}

wait_sys_boot_completed()
{
    while [ "$(getprop sys.boot_completed)" != "1" ]; do
        sleep 1
    done
}
wait_sys_boot_completed

LOG_FILE="$MODDIR/script.log"

WX_CLEAN_COUNT=0
QQ_CLEAN_COUNT=0

# 开关变量
ENABLE_WX_CLEAN=true  # 控制微信清理功能
ENABLE_QQ_CLEAN=true  # 控制QQ清理功能
ENABLE_WX_KEEPALIVE=true  # 控制微信保活功能
ENABLE_QQ_KEEPALIVE=true  # 控制QQ保活功能

log() {
    echo "$1" >> $LOG_FILE
}

is_in_recents() {
    local package=$1
    recents=$(dumpsys activity recents | grep -o "$package")
    if [ -z "$recents" ]; then
        echo "false"
    else
        echo "true"
    fi
}

get_process_count() {
    local package=$1
    count=$(pgrep -f $package | wc -l)
    echo $count
}

launch_service_if_not_alive() {
    local package=$1
    local main_service=$2
    process_count=$(get_process_count $package)
    if [ $process_count -eq 0 ]; then
        log "检测到 $package 进程不存在，尝试静默启动应用。"
        am startservice -n ${package}/${main_service} && log "$package 静默启动成功。" || log "$package 静默启动失败。"
    else
        log "$package 进程已存在，无需启动。"
    fi
}

update_module_prop() {
    sed -i 's/^description=.*/description=开机到现在已清理微信'$WX_CLEAN_COUNT'次，QQ'$QQ_CLEAN_COUNT'次/g' ${MODDIR}/module.prop
}

move_all_processes_to_background_group() {
    local package=$1
    pids=$(pgrep -f $package)
    for pid in $pids; do
        echo $pid > /dev/cpuset/background/cgroup.procs
        echo $pid > /dev/stune/background/cgroup.procs
        log "将进程 PID $pid 移动到后台组"
    done
}

while true; do
    sleep 30
    current_time=$(date '+%Y-%m-%d %H:%M:%S')
    log "$current_time"

    if [ -f "$MODDIR/disable" ]; then
        log "检测到禁用文件，停止脚本。"
        sed -i 's/^description=.*/description=已停止模块/g' ${MODDIR}/module.prop
        continue
    fi

    wx_cleared=false
    qq_cleared=false
    c=com.tencent.mm
    d=com.tencent.mobileqq

    # 微信清理逻辑
    if [ "$ENABLE_WX_CLEAN" = true ]; then
        if [ "$(is_in_recents $c)" = "false" ]; then
            wx_process_count=$(get_process_count $c)
            if [ $wx_process_count -gt 2 ]; then
                su -c "ps -ef | grep com.tencent.mm: | grep -v :push | grep -v grep | awk '{print \$2}' | xargs kill -9" && log "成功杀死非:push的WeChat进程" || log "未能杀死非:push的WeChat进程"
                move_all_processes_to_background_group $c
                wx_cleared=true
            else
                log "微信 (com.tencent.mm) 进程数为 2 或更少，无需清理。"
            fi
        else
            log "微信 (com.tencent.mm) 在前台/最近任务/小窗/分屏中，无需杀死进程。"
        fi
    else
        log "微信清理功能已禁用。"
    fi

    # QQ清理逻辑
    if [ "$ENABLE_QQ_CLEAN" = true ]; then
        if [ "$(is_in_recents $d)" = "false" ]; then
            qq_process_count=$(get_process_count $d)
            if [ $qq_process_count -gt 2 ]; then
                su -c "ps -ef | grep com.tencent.mobileqq: | grep -v :MSF | grep -v grep | awk '{print \$2}' | xargs kill -9" && log "成功杀死非:MSF的QQ进程" || log "未能杀死非:MSF的QQ进程"
                move_all_processes_to_background_group $d
                qq_cleared=true
            else
                log "QQ (com.tencent.mobileqq) 进程数为 2 或更少，无需清理。"
            fi
        else
            log "QQ (com.tencent.mobileqq) 在前台/最近任务/小窗/分屏中，无需杀死进程。"
        fi
    else
        log "QQ清理功能已禁用。"
    fi

    if [ "$wx_cleared" = true ]; then
        WX_CLEAN_COUNT=$((WX_CLEAN_COUNT+1))
    fi

    if [ "$qq_cleared" = true ]; then
        QQ_CLEAN_COUNT=$((QQ_CLEAN_COUNT+1))
    fi

    update_module_prop

    # 微信保活逻辑
    if [ "$ENABLE_WX_KEEPALIVE" = true ]; then
        launch_service_if_not_alive $c "com.tencent.mm.booter.CoreService"
    else
        log "微信保活功能已禁用。"
    fi

    # QQ保活逻辑
    if [ "$ENABLE_QQ_KEEPALIVE" = true ]; then
        launch_service_if_not_alive $d "kcsdk.shell.KcShellService"
    else
        log "QQ保活功能已禁用。"
    fi

done