##########################################################################################
#
# Magisk 模块配置脚本示例
#
##########################################################################################
##########################################################################################
#
# 说明:
#
# 1. 将您的文件放入 system 文件夹 (删除 placeholder 文件)
# 2. 将模块信息写入 module.prop
# 3. 在这个文件中进行设置 (customize.sh)
# 4. 如果您需要在启动时执行命令, 请把它们加入 common/post-fs-data.sh 或 common/service.sh
# 5. 如果需要修改系统属性(build.prop), 请把它加入 common/system.prop
#
##########################################################################################
# 配置
##########################################################################################

# 如果您需要启用 Magic Mount, 请把它设置为 true
# 大多数模块都需要启用它
AUTOMOUNT=true

# 如果您需要加载 system.prop, 请把它设置为 true
PROPFILE=false

# 如果您需要执行 post-fs-data 脚本, 请把它设置为 true
POSTFSDATA=false

# 如果您需要执行 service 脚本, 请把它设置为 true
LATESTARTSERVICE=true

##########################################################################################
# 替换列表
##########################################################################################

# 在这里构建您自己的列表，它将覆盖上面的示例
# 如果你不需要替换任何东西，!千万不要! 删除它，让它保持现在的状态
REPLACE="
/system/app/ThemeManager
"

##########################################################################################
# 自定义函数
##########################################################################################

# 这个文件 (customize.sh) 将被安装脚本在 util_functions.sh 之后 source 化(设置为环境变量)
# 如果你需要自定义操作, 请在这里以函数方式定义它们, 然后在 update-binary 里调用这些函数
# 不要直接向 update-binary 添加代码，因为这会让您很难将模块迁移到新的模板版本
# 尽量不要对 update-binary 文件做其他修改，尽量只在其中执行函数调用
