#!/system/bin/sh
# 此脚本将在late_start service 模式执行
# 如果您需要知道此脚本和模块的放置位置，请使用$MODDIR
sleep 3s
MODDIR=${0%/*}
serviced=${0%modules*}"service.d"
crondservicecomb_path=${MODDIR%/*}"/zw_crondservicecomb"
test_crond=$($(magisk --path)/.magisk/busybox/crond --help &>/dev/null;echo $?)
if [[ $test_crond != "0" ]];then
  for crond_command in $(find / -type f -name "crond" 2>/dev/null);do
    $crond_command --help &>/dev/null
    [[ $? == "0" ]] && { alias crond="$crond_command";break;}
  done
  unset crond_command
else
  alias crond="$(magisk --path)/.magisk/busybox/crond"
fi

sleep 5s
export PATH=/system/bin:$PATH
export sd=/data/media/0
FileClear_logname=FileClear_zw_11-20_16:01:50.txt
restart_time=$(date +"%Y-%m-%d %T")
nowtime=$(date +"%m-%d_%T")
sleep 8s

# 36秒后启动Crond服务
chmod -R 0777 ${MODDIR}/root
crond_pid_list=$(/system/bin/ps -ef | grep -v grep | grep "crond -c ${MODDIR}")
test -z "$crond_pid_list" && crond -c ${MODDIR}

# 开机检测Crond服务执行情况
crond_process_status() {
crond_num=$(/system/bin/ps -ef | grep -v grep | grep crond | wc -l)
if [ -n "$(/system/bin/ps -ef | grep -v grep | grep "crond -c ${MODDIR}")" ];then
  crond_ps=$(/system/bin/ps -ef | grep -v grep | grep "crond -c ${MODDIR}" | awk '{print $2,$5}')
elif [ -n "$(/system/bin/ps -ef | grep -v grep | grep "crond -c ${crondservicecomb_path}")" ];then
  crond_ps=$(/system/bin/ps -ef | grep -v grep | grep "crond -c ${crondservicecomb_path}" | awk '{print $2,$5}')
else
  crond_ps=$(/system/bin/ps -ef | grep -v grep | grep crond | sed -n '1p' | awk '{print $2,$5}')
fi
crond_pid=$(echo $crond_ps | cut -d ' ' -f 1)
crond_time=$(echo $crond_ps | cut -d ' ' -f 2)
crond_pid_cwd=$(/system/bin/ls -la /proc/$crond_pid | grep "cwd" | awk '{print $10}')
crond_pid_exe_1=$(/system/bin/ls -la /proc/$crond_pid | grep "exe" | awk '{print $10}')
crond_pid_exe_2=${crond_pid_exe_1%/*}
crond_whitelist=$(cat ${crond_pid_cwd}/* | grep -i "whitelist.sh\"$")
crond_startclear=$(cat ${crond_pid_cwd}/* | grep -i "startclear.sh\"$")
crond_qingli=$(cat ${crond_pid_cwd}/* | grep -i "qingli.sh\"$")
if [ -n "$crond_ps" ];then
  if [ "$crond_pid_cwd" == "${MODDIR}"* ];then
    crond_result_cwd="是默认路径"
  elif [ "$crond_pid_cwd" == "${crondservicecomb_path}"* ];then
    crond_result_cwd="已由'Crond服务梳理'模块接管"
  else
    crond_result_cwd="【警告】非默认路径，也许会与其他模块冲突！"
  fi
   [ -n "$crond_whitelist" ] && crond_result_whitelist=" 有'优化白名单'任务，下一行若以#开头则表示本任务不生效：" || crond_result_whitelist="【警告】没有'优化白名单'任务，怀疑与其他模块冲突！"
  [ -n "$crond_startclear" ] && crond_result_startclear=" 有'轻度清理'任务，下一行若以#开头则表示本任务不生效：" || crond_result_startclear="【警告】没有'轻度清理'任务，怀疑与其他模块冲突！"
  [ -n "$crond_qingli" ] && crond_result_qingli=" 有'深度清理'任务，下一行若以#开头则表示本任务不生效：" || crond_result_qingli="【警告】没有'深度清理'定时任务，怀疑与其他模块冲突！"
  crond_result_end=" ** Crond服务启动成功 **  \n   启动时间：${crond_time} 已启动服务总数：${crond_num}个\n  (当已启动服务超过1个时，可能存在冲突)\n   Crond命令路径：${crond_pid_exe_2}\n   Crond配置文件路径：${crond_pid_cwd} ${crond_result_cwd}\n   定时任务配置详情：\n =====================================\n  ${crond_result_whitelist}\n   ${crond_whitelist}\n …………………………………………………………\n  ${crond_result_startclear}\n   ${crond_startclear}\n …………………………………………………………\n  ${crond_result_qingli}\n   ${crond_qingli}\n …………………………………………………………\n    ** 加载Crontab定时执行服务运行结束 **
 ====================================="

else
  crond --help &>/dev/null
  [ $? != "0" ] && crond_result="【警告】Crond命令存在异常，无法运行"
  [ ! -d $crond_pid_cwd ] && crond_result_cwd="【警告】Crond配置文件夹不存在"
  [ ! -f ${crond_pid_cwd}/root ] && crond_result_cwdfile="【警告】Crond配置文件不存在"
  [ ! -f ${MODDIR}/root ] && crond_result_cwdfile+="*本模块的Crond配置文件不存在"
  crond_result_end="  ** Crond服务启动失败 **  \n  ${crond_result}  \n  ${crond_result_cwd}  \n  ${crond_result_cwdfile}"
fi
unalias crond
}
rm -rf $sd/清理日志* &>/dev/null
rm -rf $sd/adzw* &>/dev/null
sleep 2s
# 写入日志

FileClear_temp_logname=`ls -lt $sd | grep "FileClear_zw*" | sed -n "1p" | awk '{print $NF}'`
if [ -n "$FileClear_temp_logname" ]; then
  FileClear_temp_1=`grep "FileClear_for_ZW" $sd/$FileClear_temp_logname`
  if [ -n "$FileClear_temp_1" ]; then
    sed -i "17a\ " $sd/$FileClear_temp_logname
    sed -i "18a\   ** 手机重启成功：$restart_time **" $sd/$FileClear_temp_logname
    sleep 15s
    crond_process_status
    sed -i "19a\  $crond_result_end" $sd/$FileClear_temp_logname
  else
    sed -i "1i\ *" $sd/$FileClear_temp_logname
    sed -i "2i\   ** 手机重启成功：$restart_time **" $sd/$FileClear_temp_logname
    sleep 15s
    crond_process_status
    sed -i "3i\  $crond_result_end" $sd/$FileClear_temp_logname
  fi
else
  echo -e "   ** 手机重启成功：$restart_time **" >$sd/$FileClear_logname
  sleep 15s
  crond_process_status
  echo -e "  $crond_result_end" >>$sd/$FileClear_logname
fi

sleep 3s
sh /data/adb/modules/Regularfileclear/mod/whitelist.sh

sleep 2s
sh /data/adb/modules/Regularfileclear/xunhuan.sh