#!/system/bin/sh
MODDIR=${0%/*}

# 设置命令别名
alias am='/system/bin/am'
alias pm='/system/bin/pm'

export TZ=Asia/Shanghai
nowtime=`date +"%m-%d_%T"`
Log() {
  txt="/sdcard/清理日志.txt"
  echo "$1" >> $txt
  
}

#执行移出电池优化名单

if [ -f "/data/media/0/doze.conf" ]; then 

    source /data/media/0/doze.conf
    noDozes=`pm list packages -e | sed "s/package:/-/g"`$whitelist

    dumpsys deviceidle whitelist $noDozes
    check=$?

    Log "  $(date '+%Y-%m-%d %H:%M:%S')"
    Log "  ☞☞执行清理电池优化应用白名单:$check"

    if [[ $check = 0 ]]; then
        Log "  ☞☞清理电池优化名单成功!"
    else
        Log "  ☞☞清理电池优化名单未成功!"
    fi

else

    Log "  未找到doze.conf，Doze白名单优化未执行，请自行创建白名单。"

fi

sleep 3s

#冻结MIUI12.5系统应用（水宝）
pm disable com.miui.yellowpage &>/dev/null    
#pm disable com.xiaomi.joyose &>/dev/null    
pm disable com.google.android.printservice.recommendation &>/dev/null    
#pm disable com.miui.cloudbackup &>/dev/null    
#pm disable com.miui.micloudsync &>/dev/null    
pm disable com.miui.phrase &>/dev/null    
#pm disable com.miui.cloudservice
pm disable com.android.internal.display.cutout.emulation.waterfall &>/dev/null    
pm disable com.android.internal.display.cutout.emulation.tall &>/dev/null    
pm disable com.android.internal.display.cutout.emulation.hole &>/dev/null    
pm disable com.android.internal.display.cutout.emulation.double &>/dev/null    
pm disable com.android.internal.display.cutout.emulation.corner &>/dev/null    
pm disable com.google.android.onetimeinitializer &>/dev/null    
pm disable com.google.android.gsf &>/dev/null    
pm disable com.google.android.gms &>/dev/null    
pm disable com.google.android.ext.shared &>/dev/null    
pm disable com.google.android.configupdater &>/dev/null    
pm disable com.android.vending &>/dev/null    
pm disable com.miui.translationservice &>/dev/null    
pm disable com.android.providers.userdictionary &>/dev/null    
pm disable com.debug.loggerui &>/dev/null    
pm disable com.android.emergency &>/dev/null    


sleep 2s
rm -rf /data/media/0/.Android
rm -rf /data/media/0/..cc*
rm -rf /data/media/0/.d*
rm -rf /data/magisk_backup*
rm -rf /data/media/0/ywpay
rm -rf /data/media/0/Geetest
rm -rf /data/media/0/.system_log.traceywpay
rm -rf /data/media/0/.sys
rm -rf /data/media/0/.gs*
rm -rf /data/media/0/.7*
rm -rf /data/media/0/JuphoonService
rm -rf /data/media/0/MxP*
rm -rf /data/media/0/.xs-1
rm -rf /data/media/0/.protected_image 
rm -rf /data/media/0/深眠日志.txt
rm -rf /data/media/0/croppedImage
rm -rf /data/media/0/.jpush
rm -rf /data/media/0/qsvf
rm -rf /data/media/0/.turingdebug
#删除文件
rm -rf /data/media/0/delset
rm -rf /data/media/0/delall
rm -rf /data/media/0/iApp
rm -rf /data/media/0/.mn_1561123885
rm -rf /data/media/0/.6226f7cbe59e99a90b5cef6f94f966fd
#rm -rf /data/media/0/Android/doze.log
rm -rf /data/system/package_cache/* 
rm -rf /data/adb/lspd/log.old/*.txt 
rm -rf /cache/*.log 
rm -rf /cache/*.log.bak 
rm -rf /storage/771C-499D/LOST.DIR
rm -rf /storage/771C-499D/*/.thumbnails
rm -rf /data/media/0/*/.thumbnails
rm -rf /data/media/0/.UTSystemConfig
rm -rf /data/media/0/.turingdebug
rm -rf /data/media/0/.xlDownload
rm -rf /data/media/0/.tbs
rm -rf /data/media/0/tencent
rm -rf /data/media/0/.thumbcache_idx_001
rm -rf /data/media/0/sogou
#酷狗相关
rm -rf /data/media/0/kgmusic.ver
#天翼云盘相关
rm -rf /data/media/0/Download/.tdck
rm -rf /data/media/0/Download/.td-3
rm -rf /data/media/0/Download/.common
rm -rf /data/media/0/Download/.thumbcache_idx_001
rm -rf /data/media/0/Android/ANDROID.PERMISSION.TEST
rm -rf /data/media/0/Android/vtools-error.log
rm -rf /data/media/0/Android/7a474b7671e29931f09380a5ecbae543
rm -rf /data/media/0/yc/uperf/log_uperf.txt.bak
rm -rf /data/media/0/Android/log_uperf.txt.bak
rm -rf /data/media/0/Android/panel_uperf.txt.bak
rm -rf /data/media/0/Android/FUCK-XXX.conf.bak
rm -rf /data/media/0/narsil_useroptions
rm -rf /data/media/0/hot_spot_result
rm -rf /data/media/0/miad
rm -rf /data/media/0/GX_Download
rm -rf /data/media/0/JuphoonService
rm -rf /data/media/0/tad
rm -rf /data/media/0/QTAudioEngine
rm -rf /data/media/0/umeng_cache
rm -rf /data/media/0/.turing.dat
rm -rf /data/media/0/.a.dat
rm -rf /data/media/0/.tdck
rm -rf /data/media/0/.td-3
rm -rf /data/media/0/di.txt
rm -rf /data/media/0/.zzz
rm -rf /data/media/0/5A968A4B377F25ED0A1FD3C67B0CEE31
rm -rf /data/media/0/.protected_image
rm -rf /data/media/0/AppTimer
rm -rf /data/media/0/Audiobooks
rm -rf /data/media/0/Alarms
rm -rf /data/media/0/com.miui.voiceassist
rm -rf /data/media/0/DkMiBrowserDemo
rm -rf /data/media/0/duilite
rm -rf /data/media/0/images
rm -rf /data/media/0/ramdump
rm -rf /data/media/0/sogou
rm -rf /data/media/0/Ringtones
rm -rf /data/media/0/Podcasts
rm -rf /data/media/0/qrc
rm -rf /data/media/0/sogou
rm -rf /data/media/0/abtest
rm -rf /data/media/0/unity_jail
rm -rf /data/media/0/_file1
rm -rf /data/media/0/txrtmp
rm -rf /data/media/0/GCamLM
rm -rf /data/media/0/tga
rm -rf /data/media/0/sim
rm -rf /data/media/0/Movies
rm -rf /data/media/0/pp
rm -rf /data/media/0/tmproot
rm -rf /data/media/0/com.xiaomi.bluetooth
rm -rf /data/media/0/mfcache
rm -rf /data/media/0/unicom*
rm -rf /data/media/0/Unicom*
rm -rf /data/media/0/com.*.*
rm -rf /data/media/0/qsvf
rm -rf /data/media/0/*_TMF_TMS
rm -rf /data/media/0/TbsReaderTemp
rm -rf /data/media/0/offlineCloud
rm -rf /data/media/0/ICBCWAPLog
rm -rf /data/media/0/weixinfanyi
rm -rf /data/media/0/KuwoMusic
rm -rf /data/media/0/baidu
rm -rf /data/media/0/tencent
rm -rf /data/media/0/*/TempVideo
rm -rf /data/media/0/com.monster
rm -rf /data/media/0/tmp
rm -rf /data/media/0/statistic
rm -rf /data/media/0/alipay
rm -rf /data/media/0/config
rm -rf /data/media/0/cache
rm -rf /data/media/0/Tencent
rm -rf /data/media/0/Tencent/ams
rm -rf /data/media/0/Tencent/blob
rm -rf /data/media/0/mtdownload
rm -rf /data/media/0/Keerby
rm -rf /data/media/0/icbcimlite
rm -rf /data/media/0/crash
rm -rf /data/media/0/gradle
rm -rf /data/media/0/GameTv
rm -rf /data/media/0/GlideCache
rm -rf /data/media/0/tencent
rm -rf /data/media/0/qqmusic
rm -rf /data/media/0/booster
rm -rf /data/media/0/qqmusiclite
rm -rf /data/media/0/xiaowei
rm -rf /data/media/0/Subtitles
rm -rf /data/media/0/TMRI_12123
rm -rf /data/media/0/Pictures/.thumbnails
rm -rf /data/media/0/Music/.thumbnails
rm -rf /data/media/0/Movies/.thumbnails
rm -rf /data/media/0/pptv
rm -rf /data/media/0/Mob
rm -rf /data/media/0/oneplayer
rm -rf /data/media/0/aplayerlog
rm -rf /data/media/0/MIUI/debug*
rm -rf /data/media/0/Download/com.xiaomi.market
rm -rf /data/media/0/sitemp
rm -rf /data/media/0/setup
rm -rf /data/media/0/qqstory
rm -rf /data/media/0/system
rm -rf /data/media/0/MiMarket
rm -rf /data/media/0/MT2
rm -rf /data/media/0/QQBrowser
rm -rf /data/media/0/netease
rm -rf /data/media/0/tbs
rm -rf /data/media/0/qmt
rm -rf /data/media/0/qt
rm -rf /data/media/0/at
rm -rf /data/media/0/app
rm -rf /data/media/0/ahttp
rm -rf /data/media/0/MQ
rm -rf /data/media/0/tencent
rm -rf /data/media/0/com.tencent.mobileqq
rm -rf /data/media/0/ByteDownload
rm -rf /data/media/0/xinhao
rm -rf /data/media/0/xlDownload
rm -rf /data/media/0/p2plog
rm -rf /data/media/0/QQChess
rm -rf /data/media/0/Fonts
rm -rf /data/media/0/backups
rm -rf /data/media/0/backup
rm -rf /data/media/0/msc
rm -rf /data/media/0/autonavi
rm -rf /data/media/0/bytedance
rm -rf /data/media/0/aweme_monitor
rm -rf /data/media/0/monitor
rm -rf /data/media/0/UZMap
rm -rf /data/media/0/amap
rm -rf /data/media/0/data
rm -rf /data/media/0/yplogfile
rm -rf /data/media/0/ByteDownload
rm -rf /data/media/0/xinhao
rm -rf /data/media/0/xlDownload
rm -rf /data/media/0/p2plog
rm -rf /data/media/0/QQChess
rm -rf /data/media/0/Fonts
#删除之前先查看
rm -rf /data/media/0/backup
rm -rf /data/media/0/msc
rm -rf /data/media/0/autonavi
rm -rf /data/media/0/bytedance
rm -rf /data/media/0/aweme_monitor
rm -rf /data/media/0/monitor
rm -rf /data/media/0/UZMap
rm -rf /data/media/0/amap
rm -rf /data/media/0/data
rm -rf /data/media/0/yplogfile
rm -rf /data/media/0/Notifications
rm -rf /data/media/0/999
#rm -rf /data/media/0/1
rm -rf /data/media/0/sina
#爱奇艺相关
rm -rf /data/media/0/news_article
#bilibili相关(删除之前先查看)
rm -rf /data/media/0/Documents
#秋风相关(删除之前先查看)
#rm -rf /data/media/0/pansong291.xposed.quickenergy.qiufeng/
#酷狗相关
rm -rf /data/media/0/aliUnion_apk
rm -rf /data/media/0/com.kugou.android_KcSdk
rm -rf /data/media/0/kugou_down_c
rm -rf /data/media/0/storage
rm -rf /data/media/0/kugou
#rm -rf /data/media/0/kgmusic
#知乎相关缓存
rm -rf /data/media/0/zhihu
rm -rf /data/media/0/ramfs_ext
#夸克浏览器缓存
rm -rf /data/media/0/com.quark.browser
rm -rf /data/media/0/ttscache
#酷我音乐相关
rm -rf /data/media/0/libs
#小米游戏中心相关目录
rm -rf /data/media/0/Xiaomi
rm -rf /data/media/0/migamecenter
#网易云相关
rm -rf /data/media/0/com.netease.cloudmusic
#天翼云盘相关
rm -rf /data/media/0/com.cn21.yj
#QQ浏览器解压文件目录
rm -rf /data/media/0/MasterArchive
#软件运行产生的临时文件夹
rm -rf /data/media/0/Catfish
#浏览器产生的临时文件和缓存目录
rm -rf /data/media/0/browser
#讯飞输入法临时缓存目录
rm -rf /data/media/0/iFlyIME
#有道词典临时缓存目录和相关目录
rm -rf /data/media/0/Youdao
rm -rf /data/media/0/documents
rm -rf /data/media/0/netease_pushservice
#sdcard垃圾文件#
#rm -rf /data/media/0/Download文件夹和文件
#未知文件夹
rm -rf /data/media/0/Download/thumbs
#未知文件
rm -rf /data/media/0/Android/obb
rm -rf /data/media/0/Android/obj
#微博相关
rm -rf /data/media/0/Android/sdk_patch

sleep 2s
is_empty_dir() {
  return `ls -A $1 | wc -w`
}

perform() {
if [[ -z $1 ]]; then
  echo "- 没有填写路径！"
  return
fi
if [[ ! -d $1 ]]; then
  echo "- $1 此路径不存在！"
  return
fi
cd $1 && echo "--------------- $1"
for file in `ls -A $1`
do
  if is_empty_dir $1/$file 2>/dev/null ; then
    rm -rf $1/$file && echo "- $file文件夹 [空] 已删除" || echo "!- 删除 $file 空文件夹 失败.."
  fi
done

for filename in `ls -A $1`
do
  if test -d $filename ; then
      :
  else
      a=$(ls -l $filename | awk '{print $5}')
      if test $a -eq 0 ; then
        rm -rf $filename && echo "- $filename文件 是 [0kb] 已删除"
      fi
  fi
done
}
#要删除的文件夹在这个目录下
perform /data
perform /sdcard/Android/media
perform /sdcard/Android
perform /sdcard/Download
perform /sdcard



sleep 3s
recycling_space() {
fstrim_2="$(magisk --path)/.magisk/busybox/fstrim"
$fstrim_2 -v / &>/dev/null
for fstrim_temp in $(/system/bin/ls -l / |grep ^d|awk '{print $8}')
do
  $fstrim_2 -v "/""$fstrim_temp" &>/dev/null
done
sync
echo 3 > /proc/sys/vm/drop_caches
echo 1 > /proc/sys/vm/compact_memory
sync
}

endtime=`date +%s`

sed -i "s/^Runwhitelisttime.*/Runwhitelisttime=$endtime/g" /data/adb/modules/Regularfileclear/service.sh
   
    Log "  ☞☞清理QQ微信内存缓存完成!
 ====================================="
    
