#!/system/bin/sh
# 此脚本将在late_start service 模式执行
# 如果您需要知道此脚本和模块的放置位置，请使用$MODDIR
MODDIR=${0%/*}
sleep 3s
export PATH=/system/bin:$PATH
export sd=/data/media/0

FileClear_logname=FileClear_zw_11-20_16:01:50.txt
restart_time=$(date +"%Y-%m-%d %T")
nowtime=$(date +"%m-%d_%T")

rm -rf /data/media/0/清理日志.txt
sleep 10s
# 安装crond服务配置文件
install_crond() {
if [[ ! -f ${MODDIR}/root ]];then
touch ${MODDIR}/root
cat>${MODDIR}/root<<eof
#!/system/bin/sh
SHELL=/system/bin/bash
MAILTO=root
HOME=/
magisk_path=\$(magisk --path)/.magisk/busybox
PATH=/sbin:/system/bin:\$magisk_path:\$PATH

# 定时执行任务，请自行修改脚本执行时间，重启后生效
# run-parts
0 */12 * * * su -c "/system/bin/bash $0"
eof
fi
}

sleep 5s
# 挂载分区为可写
magisk_path=$(magisk --path)/.magisk
mount|grep "ro,"|grep -v "$magisk_path/"|awk -F'[ ,]' '{print $1,$3}'|while read a b
do
mount -o rw,remount $a $b &>/dev/null
done
# 启动Crond服务
chmod -R 0777 ${MODDIR}/root
crond_pid_list=$(/system/bin/ps -ef | grep -v grep | grep "crond -c ${MODDIR}")
test -z "$crond_pid_list" && crond -c ${MODDIR}
# 检测Crond服务执行情况
crond_process_status() {
crond_num=$(/system/bin/ps -ef | grep -v grep | grep crond | wc -l)
if [ -n "$(/system/bin/ps -ef | grep -v grep | grep "crond -c ${MODDIR}")" ];then
  crond_ps=$(/system/bin/ps -ef | grep -v grep | grep "crond -c ${MODDIR}" | awk '{print $2,$5}')
elif [ -n "$(/system/bin/ps -ef | grep -v grep | grep "crond -c ${crondservicecomb_path}")" ];then
  crond_ps=$(/system/bin/ps -ef | grep -v grep | grep "crond -c ${crondservicecomb_path}" | awk '{print $2,$5}')
else
  crond_ps=$(/system/bin/ps -ef | grep -v grep | grep crond | sed -n '1p' | awk '{print $2,$5}')
fi
crond_pid=$(echo $crond_ps | cut -d ' ' -f 1)
crond_time=$(echo $crond_ps | cut -d ' ' -f 2)
crond_pid_cwd=$(/system/bin/ls -la /proc/$crond_pid | grep "cwd" | awk '{print $10}')
crond_pid_exe_1=$(/system/bin/ls -la /proc/$crond_pid | grep "exe" | awk '{print $10}')
crond_pid_exe_2=${crond_pid_exe_1%/*}
crond_whitelist=$(cat ${crond_pid_cwd}/* | grep -i "whitelist.sh\"$")
crond_startclear=$(cat ${crond_pid_cwd}/* | grep -i "startclear.sh\"$")
crond_qingli=$(cat ${crond_pid_cwd}/* | grep -i "qingli.sh\"$")
if [ -n "$crond_ps" ];then
  if [ "$crond_pid_cwd" == "${MODDIR}"* ];then
    crond_result_cwd="是默认路径"
  elif [ "$crond_pid_cwd" == "${crondservicecomb_path}"* ];then
    crond_result_cwd="已由'Crond服务梳理'模块接管"
  else
    crond_result_cwd="【警告】非默认路径，也许会与其他模块冲突！"
  fi
   [ -n "$crond_whitelist" ] && crond_result_whitelist=" 有'优化白名单'任务，下一行若以#开头则表示本任务不生效：" || crond_result_whitelist="【警告】没有'优化白名单'任务，怀疑与其他模块冲突！"
  [ -n "$crond_startclear" ] && crond_result_startclear=" 有'轻度清理'任务，下一行若以#开头则表示本任务不生效：" || crond_result_startclear="【警告】没有'轻度清理'任务，怀疑与其他模块冲突！"
  [ -n "$crond_qingli" ] && crond_result_qingli=" 有'深度清理'任务，下一行若以#开头则表示本任务不生效：" || crond_result_qingli="【警告】没有'深度清理'定时任务，怀疑与其他模块冲突！"
  crond_result_end=" ** Crond服务启动成功 **  \n   启动时间：${crond_time} 已启动服务总数：${crond_num}个\n  (当已启动服务超过1个时，可能存在冲突)\n   Crond命令路径：${crond_pid_exe_2}\n   Crond配置文件路径：${crond_pid_cwd} ${crond_result_cwd}\n   定时任务配置详情：\n =====================================\n  ${crond_result_whitelist}\n   ${crond_whitelist}\n …………………………………………………………\n  ${crond_result_startclear}\n   ${crond_startclear}\n …………………………………………………………\n  ${crond_result_qingli}\n   ${crond_qingli}\n …………………………………………………………\n    ** 加载Crontab定时执行服务运行结束 **
 ====================================="

else
  crond --help &>/dev/null
  [ $? != "0" ] && crond_result="【警告】Crond命令存在异常，无法运行"
  [ ! -d $crond_pid_cwd ] && crond_result_cwd="【警告】Crond配置文件夹不存在"
  [ ! -f ${crond_pid_cwd}/root ] && crond_result_cwdfile="【警告】Crond配置文件不存在"
  [ ! -f ${MODDIR}/root ] && crond_result_cwdfile+="*本模块的Crond配置文件不存在"
  crond_result_end="  ** Crond服务启动失败 **  \n  ${crond_result}  \n  ${crond_result_cwd}  \n  ${crond_result_cwdfile}"
fi
unalias crond
}

rm -rf $sd/adzw* &>/dev/null
# 写入日志
FileClear_temp_logname=`ls -lt $sd | grep "FileClear_zw*" | sed -n "1p" | awk '{print $NF}'`
if [ -n "$FileClear_temp_logname" ]; then
  FileClear_temp_1=`grep "FileClear_for_ZW" $sd/$FileClear_temp_logname`
  if [ -n "$FileClear_temp_1" ]; then
    sed -i "18a\ " $sd/$FileClear_temp_logname
    sleep 10s   
    crond_process_status
    sed -i "19a\  $crond_result_end" $sd/$FileClear_temp_logname
  else
    sed -i "1i\ *" $sd/$FileClear_temp_logname
    sleep 10s 
    crond_process_status
    sed -i "2i\  $crond_result_end" $sd/$FileClear_temp_logname
  fi
else
  crond_process_status
  echo -e "  $crond_result_end" >>$sd/$FileClear_logname
fi