#!/system/bin/sh
Seylia=${0%/*}
rm -rf /cache/EvoMem.log
cp -n $Seylia/EvoMem.conf /data
get_prop() {
  EvoMem_config="/data/EvoMem.conf"
  cat $EvoMem_config | grep -v '^#' | grep "^$1=" | cut -f2 -d '='
}
log() {
  if ${enable_log}; then
    log_file="/cache/EvoMem.log"
    touch /cache/EvoMem.log
    echo "[$(date | awk '{print $4}')] $@" >>"$log_file"
  fi
}
affinity=$(get_prop zram_cpu_efficient)
io=$(get_prop modify_io_parameters)
memopt=$(get_prop bootup_optimize_mem)
enable_log=$(get_prop enable_log)
log "模块开始运行"
. $Seylia/EvoMem