#!/system/bin/sh
# 不要假设您的模块将位于何处。
# 如果您需要知道此脚本和模块的放置位置，请使用$MODDIR
# 这将确保您的模块仍能正常工作
# 即使Magisk将来更改其挂载点
MODDIR=${0%/*}

# 此脚本将在late_start service 模式执行

# 等待开机30秒后开始执行
sleep 30

swapoff /dev/block/zram0 2>/dev/null
echo 1 > /sys/block/zram0/reset

# 等待开机60秒后检查是否关闭成功，未关闭则重试
sleep 60
zramdisksize=`cat /sys/block/zram0/disksize`
if [[ $zramdisksize -ne 0 ]]; then
  echo "再次尝试关闭ZRAM"
  swapoff /dev/block/zram0 2>/dev/null
  swapoff /dev/block/zram1 2>/dev/null
  swapoff /dev/block/zram2 2>/dev/null
  echo 1 > /sys/block/zram0/reset
fi


# 结束
exit 0
