SKIPMOUNT=false
PROPFILE=false
POSTFSDATA=false
LATESTARTSERVICE=true

volume_keytest() {
  ui_print "--- 音量键测试 ---"
  ui_print "  请按音量+或-键"
  (/system/bin/getevent -lc 1 2>&1 | /system/bin/grep VOLUME | /system/bin/grep " DOWN" > "$TMPDIR"/events) || return 1
  return 0
}

volume_choose() {
  while (true); do
    /system/bin/getevent -lc 1 2>&1 | /system/bin/grep VOLUME | /system/bin/grep " DOWN" > "$TMPDIR"/events
      if (`cat "$TMPDIR"/events 2>/dev/null | /system/bin/grep VOLUME >/dev/null`); then
          break
      fi
  done
  if (`cat "$TMPDIR"/events 2>/dev/null | /system/bin/grep VOLUMEUP >/dev/null`); then
      return 1
  else
      return 0
  fi
}

run_volume_key_test() {
  if volume_keytest; then
    KEYTEST=volume_choose
    ui_print "- 音量键测试完成"
  else
    KEYTEST=false
    ui_print " ！错误：没有检测到音量键选择，默认添加温控"
  fi
}

run_temp() {
  ui_print " "
  ui_print "--- 根据自己的喜好选择是否添加温控 ---"
  ui_print "  音量+键 = 添加温控，当温度高于56℃时停止充电，低于45℃时恢复充电"
  ui_print "  音量-键 = 不添加温控，真·极速快充，高温伤手又伤机，谨慎选择！"
  ui_print " "

  if "$KEYTEST"; then
    ui_print "- 不添加温控"
    sed -i '31,37d' $TMPDIR/service.sh
  else
    ui_print "- 添加温控"
  fi
}

print_modname() {
ui_print "
 ********************************************************
 
 - 模块: $MODNAME
 - 模块ID: $MODID
 - 作者: $MODAUTHOR
 
 -      模块介绍↓
 - 删除温控，关闭阶梯式充电
 - 持续修改电池温度，让系统认为电池温度一直是25℃
 - 持续修改充电电流，以达到最快充电速度
 
 ********************************************************
 - 设备相关信息↓
 - SDK: $Sdk
 - 设备: $Device
 - 设备代号: $device
 - 安卓版本: Android $Android
 ********************************************************
 
 - 全机型测试，可能正常使用（小米10Ultra必能正常使用）
 - 若能正常使用，还请点赞评论关注收藏
 - 若不能正常使用，也请在评论区说一下手机型号，但并不会进行适配
 - 水平有限，手头又没有其他手机，只能做到这了，私密马赛
 
 ********************************************************
 "
}

on_install() {
  thermals=`ls /system/bin/*thermal* /system/etc/init/*thermal* /system/etc/perf/*thermal* /system/vendor/bin/*thermal* /system/vendor/etc/*thermal* /system/vendor/etc/powerhint* /system/vendor/etc/init/*_thermal* /system/vendor/etc/perf/*thermal* /system/vendor/lib/hw/thermal* /system/vendor/lib64/hw/thermal*`
  for thermal in $thermals
  do
      mkdir -p $MODPATH/${thermal%/*}
      touch $MODPATH/$thermal
  done
  [[ -f /data/current ]] && rm -rf /data/current
  chattr -i /data/vendor/thermal/config
  rm -rf /data/vendor/thermal/config/*
  chattr +i /data/vendor/thermal/config
  chattr +i /data/vendor/thermal
}

set_permissions() {
  set_perm_recursive  $MODPATH  0  0  0755  0644
}