#!/system/bin/sh

set_value() {
    if [[ -f "$1" ]];then
        chmod 0777 "$1"
        echo "$2" > "$1"
    fi
}

types=`ls /sys/class/thermal/thermal_*/type`
for type in $types
do
    [[ `cat $type` == "gpuss-0-usr" ]] && temp=${type%/*}/temp
done

constants=`ls /sys/class/power_supply/*/*current_max`
until [[ "1" == "2" ]];do
    set_value /sys/class/power_supply/battery/battery_charging_enabled 1
    set_value /sys/class/power_supply/battery/input_suspend 0
    set_value /sys/class/qcom-battery/restricted_charging 0
    set_value /sys/class/power_supply/battery/step_charging_enabled 0
    set_value /sys/class/power_supply/usb/boost_current 1
    set_value /sys/class/power_supply/battery/restricted_charging 0
    set_value /sys/class/power_supply/usb/pd_allowed 1
    set_value /sys/class/power_supply/allow_hvdcp3 1
    set_value /sys/class/power_supply/battery/subsystem/usb/pd_allowed 1
    set_value /sys/class/power_supply/battery/safety_timer_enabled 0
    set_value /sys/class/power_supply/bms/temp_warm 800
    set_value /sys/class/power_supply/bms/temp 250
    set_value /sys/class/power_supply/battery/temp 250
    if [[ `cat $temp` -gt 56000 ]];then
        until [[ `cat $temp` -le 45000 ]];do
            set_value /sys/class/power_supply/battery/battery_charging_enabled 0
            set_value /sys/class/power_supply/battery/input_suspend 1
            sleep 1
        done
    fi
    for constant in $constants
    do
        set_value $constant 15000000
    done
    sleep 1
done
