#!/system/bin/sh
MODDIR=${0%/*}
MODID=${MODDIR##*/}
START_LOG=$MODDIR/Status
MODPATH=/data/adb/modules/HID_Mao
#默认日志记录到面具日志
SD=/cache/magisk.log

function log_key() {
 test ! -e $SD && mkdir -p $SD
 echo -e "\n时间: "$(date +%H:%M:%S)"－电量: "$(dumpsys battery | awk '/level/{print $2}')" "$1" " >>$SD
}

read_settings() {
 [[ -f "$MODPATH/配置.ini" ]] && cat $MODPATH/配置.ini | awk '!/#/ {print $0}' | sed -n "s/^${1}=//p"
}

#1如果屏幕关
Numericalv=$(sed '/^Screen=/!d;s/.*=//' $START_LOG)
Screen_Open=$(dumpsys window policy | grep "mInputRestricted" | cut -d= -f2)

if [[ $Screen_Open == "true" ]]; then
 echo "Screen=1" >$MODDIR/Status
else
 #1如果屏幕开
 if [[ $Numericalv == "1" ]]; then
  rm -f $START_LOG
  status1a=$(read_settings 随机ID)
  status2a=$(read_settings 自定义功能)
  status3a=$(read_settings 自定义启动日志)
  #亮屏切换ID
  if [[ $status1a == "2" ]]; then
   sh $MODDIR/Set_ID.sh
  fi
  if [[ $status2a == "开" ]]; then
   sh $MODPATH/自定义亮屏执行.sh
   if [[ $status3a == "开" ]]; then
    log_key "自定义亮屏命令已执行️️"
   fi
  fi
 fi
fi
