#!/system/bin/sh
MODDIR=${0%/*}
SD=/cache/magisk.log
MODPATH=/data/adb/modules/HID_Mao
Stop=$(sed '/^随机ID=/!d;s/.*=//' $MODPATH/配置.ini)
ID=$(sed '/^固定ID=/!d;s/.*=//' $MODPATH/配置.ini)

function log_key() {
 test ! -e $SD && mkdir -p $SD
 echo -e "\n时间: "$(date +%H:%M:%S)"－电量: "$(dumpsys battery | awk '/level/{print $2}')" "$1" " >>$SD
}
function read_settings() {
 [[ -f "$MODPATH/配置.ini" ]] && cat $MODPATH/配置.ini | awk '!/#/ {print $0}' | sed -n "s/^${1}=//p"
}
function rand(){ 
 min=$1
 max=$(($2-$min+1))
 num=$(cat /dev/urandom | head -n 9 | cksum | awk -F ' ' '{print $1}')
 echo $(($num%$max+$min))
}

Time_ID=$(rand 1100000000 2000000000)

if [[ $Stop == "1" ]]; then
 echo $Time_ID >$MODDIR/ID
 log_key "(开机)设置随机ID:"$Time_ID
else
 if [[ $Stop == "2" ]]; then
  status4a=$(read_settings 随机ID日志)
  if [[ $status4a == "开" ]]; then
   log_key "设置随机ID:"$Time_ID
  fi
  echo $Time_ID >$MODDIR/ID
 elif [[ $Stop == "3" ]]; then
  echo $ID >$MODDIR/ID
 fi
fi
sleep 2
$MODDIR/Set_ID $(cat $MODDIR/ID)