#!/bin/sh
# Copyright 2023 AzukiAtsui

# Get this module’s base directory path.
MODDIR=${0%/*}

. "$MODDIR/scripts/check-env.sh"

# Wait for system boot process done.
while [ "$(getprop sys.boot_completed)" != "1" ]; do
  sleep 2
done

# Delete the test-flag file created by `post-fs-data.sh`.
rm -f "$MODDIR/test"

# Show seconds on status bar.
settings put secure clock_seconds 1

# Make SafetyNet pass.
resetprop ro.boot.flash.locked 1

# Revert changes when boot completed.
resetprop ro.boot.vbmeta.device_state locked
resetprop ro.boot.verifiedbootstate green

#resetprop ro.boot.veritymode ""
#set-verity-state 0
resetprop ro.debuggable 0

# LTPO enhancement author int萌新很新@coolapk.
# Recovery vrr and adfr to enable LTPO.
resetprop persist.oplus.display.vrr 1
resetprop persist.oplus.display.vrr.adfr 2
settings put system peak_refresh_rate 59.0
settings put system min_refresh_rate 59.0

# Disable Android Verified Boot.
avb 3

# 刷新双开支持列表
. "$MODDIR/scripts/oplus-mod.sh"
oplus_multi_app

# from 望月古川@coolapk
rmmod qcom_spmi_temp_alarm
rmmod thermal_minidump
rmmod thermal_pause

# 系统更新进程优化
pgrep update_engine >/dev/cpuset/top-app/tasks
taskset -p "ff" -a "$(pgrep update_engine)"
renice -n -20 "$(pgrep update_engine)"

# 触控手感 by int萌新很新@coolapk
echo 5 > /proc/touchpanel/sensitive_level
echo 2 > /proc/touchpanel/smooth_level
echo 1 > /proc/game_opt/disable_cpufreq_limit
