#!/bin/sh
# Copyright 2023 AzukiAtsui

# 将缩写 ColorOS 13 为 cos13，余各版本以此类推。
# 若在 realmeUI 和 cos 有同名文件，则只注 cos 版本，
# 否则注 rui 版本（rui2≈cos11; rui3≈cos12; rui4≈cos13）。
if [ "$API" -le 30 ]; then
  # cos11
  OPLUS_ADFR_CONFIG=/my_product/etc/oplus_adfr_config.json
  OPLUS_DISPLAY_PERF_LIST=/my_product/vendor/etc/oppo_display_perf_list.xml
else
  # cos12~13
  OPLUS_ADFR_CONFIG=/my_product/etc/oplus_vrr_config.json
  OPLUS_DISPLAY_PERF_LIST=/my_product/vendor/etc/multimedia_display_perf_list.xml
fi
# Usually directories temperature_profile and ThermalServiceConfig are placed in /my_product/etc on cos11
# and are placed in /odm/etc on cos12~13. Some specific products have thermal directories in /my_bigball/etc.
OPLUS_TEMPERATURE_PROFILE_DIR=$(find /my_product/etc /odm/etc /my_bigball/etc \
  -type d -name 'temperature_profile' 2>/dev/null | head -n 1)
OPLUS_ThermalServiceConfig=$(find /my_product/etc /odm/etc /my_bigball/etc \
  -type d -name 'ThermalServiceConfig' 2>/dev/null | head -n 1)
OPLUS_FTF='find /data/oppo/coloros/startup/ /data/oplus/os/startup/ -type f -name'


#### /my_product partition files below ####
# Change bootanimation. This function works on ColorOS and realmeUI.
oplus_bootanimation() {
  mkdir -p "$MOD_ROOT/my_product/media/bootanimation"
  mv -f "$MOD_ROOT/bootanimation/bootanimation.zip" "$MOD_ROOT/my_product/media/bootanimation/bootanimation.zip"
  mv -f "$MOD_ROOT/bootanimation/rbootanimation.zip" "$MOD_ROOT/my_product/media/bootanimation/rbootanimation.zip"
  mv -f "$MOD_ROOT/bootanimation/poweron.ogg" "$MOD_ROOT/my_product/media/bootanimation/poweron.ogg"
  mv -f "$MOD_ROOT/bootanimation/poweroff.ogg" "$MOD_ROOT/my_product/media/bootanimation/poweroff.ogg"
  set_perm_recursive "$MOD_ROOT/my_product/media/bootanimation" 0 0 777 777 u:object_r:system_file:s0
  which_mount "/my_product/media/bootanimation"
}

# Oplus multimedia display perf list 视频播放器帧率控制
oplus_display_perf_list() {
  oplus_display_perf_list_mod(){
    sed -i '/<fps>/d;/<vsync>/d' "$1" && ui_print "- [修改] 删除“锁帧”、“垂直同步”标签。"
  }
  file_mod_template "$OPLUS_DISPLAY_PERF_LIST" "oplus_display_perf_list_mod"
}

# ColorOS 13 systemUI feature
oplus_sysui_cos13() {
  OPLUS_SYS_UI_XML="/my_product/etc/extension/feature_common_com.android.systemui.xml"
  oplus_sysui_cos13_sed(){
    sed -i -e '/enable_fp_blind_unlock/d' \
      -e '/disable_fp_blind_unlock/d' \
      -e '/<extend_features>/a <app_feature name="com.android.systemui.enable_fp_blind_unlock"/>' \
      "$1" && \
      ui_print "- [修改] 尝试启用息屏指纹盲解。"
    sed -i '/disable_volume_blur/d' "$1" && ui_print "- [修改] 删除“禁用音量面板模糊”标签。"
  }
  file_mod_template "$OPLUS_SYS_UI_XML" "oplus_sysui_cos13_sed"
}

# realmeUI 3~4 extend features such as: move DC dimming to developer settings.
oplus_extend_feature_rui3_4() {
  OPLUS_EX_FEATURE_XML=$(find /my_product/etc/extension/ -type f \
    -iname "realme_product_rom_extend_feature_$(getprop ro.separate.soft).xml" 2>/dev/null)
  oplus_ex_feature_xml(){
    sed -i '/move_dc_to_develop/d' "$1" && ui_print "- [修改] 删除“移动DC调光到开发者选项”标签。"
  }
  file_mod_template "$OPLUS_EX_FEATURE_XML" "oplus_ex_feature_xml"
}

# 应用动画速度调节
oplus_app_features() {
  OPLUS_APP_FEATURES=/my_product/etc/extension/com.oplus.app-features.xml
  oplus_app_features_mod(){
    sed -i '/DEVICE_LEVEL_HIGH/d' "$1" && ui_print "- [修改] 删除“高端设备”标签，目的：应用动画速度调节。"
  }
  file_mod_template "$OPLUS_APP_FEATURES" "oplus_app_features_mod"
}

# 自带APN接入点配置  解除修改限制
oplus_apns_conf() {
  OPLUS_APNS_CONF=/my_product/etc/apns-conf.xml
  [ -f $OPLUS_APNS_CONF ] || OPLUS_APNS_CONF=/system/product/etc/apns-conf.xml
  oplus_apns_conf_mod(){
    sed -i '/read_only/s/true/false/g' "$1" && ui_print "- [修改] 禁用默认接入点修改限制。"
  }
  file_mod_template "$OPLUS_APNS_CONF" "oplus_apns_conf_mod"
}

# Screen refresh rate list of applications
oplus_refresh_rate_config() {
  OPLUS_REFRESH_RATE_CONFIG=/my_product/etc/refresh_rate_config.xml
  oplus_refresh_rate_config_mod(){
    # sed -i 's/rateId="[0-9]-[0-9]-[0-9]-[0-9]/rateId="3-0-2-3/g' \
    #   "$1" && ui_print "- [修改] APP刷新率模式为 3-0-2-3，默认推荐。"
    sed -i 's/rateId="[0-9]-[0-9]-[0-9]-[0-9]/rateId="0-0-0-0/g' \
      "$1" && ui_print "- [修改] APP刷新率模式为 0-0-0-0，全局自适应。"
    sed -i 's/inputMethodLowRate="true/inputMethodLowRate="false/g' \
      "$1" && ui_print "- [修改] 禁用输入法降帧。"
    # sed -i 's/enableRateOverride="true/enableRateOverride="false/g' \
    #   "$1" && ui_print "- [修改] 禁用surfaceview，texture场景降帧。"
    # sed -i 's/disableViewOverride="true/disableViewOverride="false/g' \
    #   "$1" && ui_print "- [修改] 禁用disableViewOverride。"
    # sed -i 's/adfr="true/adfr="false/g' "$1" && ui_print "- [修改] 禁用adfr动态刷新率。"
    sed -n -i '/example/p;/item/d;p' "$1" && \
      ui_print "- [修改] 删除 item标签，但有example字段的行除外。"
  }
  file_mod_template "$OPLUS_REFRESH_RATE_CONFIG" "oplus_refresh_rate_config_mod"
}

# adfr(Dynamic refresh rate)
oplus_adfr_config() {
  oplus_adfr_config_mod(){
    sed -i '/adfr_enable/s/true/false/g' "$1" && ui_print "- [修改] 禁用adfr动态刷新率。"
  }
  file_mod_template "$OPLUS_ADFR_CONFIG" "oplus_adfr_config_mod"
}


# 高温保护
oplus_high_temp_protect() {
  OPLUS_HIGH_TEMP_PROTECT="$OPLUS_TEMPERATURE_PROFILE_DIR/sys_high_temp_protect_$(echo "$PRODUCT_BRAND" | sed 's/ /_/')_$PROJECT_NAME.xml"
  oplus_high_temp_protect_mod(){
    sed -i '/HighTemperatureProtectSwitch>/s/true/false/g' "$1" && ui_print "- [修改] 禁用高温保护。"
    sed -i '/HighTemperatureShutdownSwitch>/s/true/false/g' "$1" && ui_print "- [修改] 禁用高温关机。"
    sed -i '/HighTemperatureFirstStepSwitch>/s/true/false/g' "$1" && ui_print "- [修改] 禁用高温第一步骤。"
    sed -i '/HighTemperatureDisableFlashSwitch>/s/true/false/g' "$1" && ui_print "- [修改] 禁用高温禁用手电。"
    sed -i '/HighTemperatureDisableFlashChargeSwitch>/s/true/false/g' "$1" && ui_print "- [修改] 禁用“高温禁用闪充”。"
    sed -i '/HighTemperatureControlVideoRecordSwitch>/s/true/false/g' \
      "$1" && ui_print "- [修改] 禁用高温视频录制控制。"
    sed -i -e '/HighTemperatureShutdownUpdateTime/d' \
      -e '/HighTemperatureProtectFirstStepIn/d' \
      -e '/HighTemperatureProtectFirstStepOut/d' \
      -e '/HighTemperatureProtectThresholdIn/d' \
      -e '/HighTemperatureProtectThresholdOut/d' \
      -e '/HighTemperatureProtectShutDown/d' \
      -e '/HighTemperatureDisableFlashLimit/d' \
      -e '/HighTemperatureEnableFlashLimit/d' \
      -e '/HighTemperatureDisableFlashChargeLimit/d' \
      -e '/HighTemperatureEnableFlashChargeLimit/d' \
      -e '/HighTemperatureDisableVideoRecordLimit/d' \
      -e '/HighTemperatureEnableVideoRecordLimit/d' \
      "$1" && ui_print "- [修改] 删除部分 Time, In/Out, Dis/Enable 项。"
    sed -i '/camera_temperature_limit>/s/>[0-9]*</>600</g' "$1" && ui_print "- [修改] “相机温度限制”标签值：600。"
    sed -i '/ToleranceFirstStepIn>/s/>[0-9]*</>600</g' "$1" && ui_print "- [修改] ToleranceFirstStepIn标签值：600。"
    sed -i '/ToleranceFirstStepOut>/s/>[0-9]*</>580</g' "$1" && ui_print "- [修改] ToleranceFirstStepOut标签值：580。"
    sed -i '/ToleranceSecondStepIn>/s/>[0-9]*</>620</g' "$1" && ui_print "- [修改] ToleranceSecondStepIn标签值：620。"
    sed -i '/ToleranceSecondStepOut>/s/>[0-9]*</>600</g' "$1" && ui_print "- [修改] ToleranceSecondStepOut标签值：600。"
    sed -i '/ToleranceStart>/s/>[0-9]*</>540</g' "$1" && ui_print "- [修改] ToleranceStart标签值：540。"
    sed -i '/ToleranceStop>/s/>[0-9]*</>520</g' "$1" && ui_print "- [修改] ToleranceStop标签值：520。"
    ui_print "- 请避免手机长时间处于高温状态（约44+℃）。"
    ui_print "* 高温可加速电池去世，甚至导致手机故障、主板损坏、火灾等危害！"
  }
  file_mod_template "$OPLUS_HIGH_TEMP_PROTECT" "oplus_high_temp_protect_mod"
}

# 高热配置
oplus_thermal_config() {
  OPLUS_THERMAL_CONFIG=$OPLUS_ThermalServiceConfig/sys_thermal_config.xml
  oplus_thermal_config_mod(){
    sed -i '/is_upload_dcs>/s/1/0/g' "$1" && \
      ui_print "- [修改] 禁用上传dcs。"
    sed -i '/is_upload_log>/s/1/0/g' "$1" && \
      ui_print "- [修改] 禁用上传log。"
    sed -i '/is_upload_errlog>/s/1/0/g' "$1" && \
      ui_print "- [修改] 禁用上传错误log。"
    sed -i '/thermal_battery_temp>/s/1/0/g' "$1" && \
      ui_print "- [修改] 禁用“thermal_battery_temp(热之电池温度？)”。"
    sed -i '/thermal_heat_path/d' "$1" && \
      ui_print "- [修改] 删除“thermal_heat_path(热量路径？)”标签。"
    sed -i '/detect_environment_time_threshold>[0-9]*</d' "$1" && \
      ui_print "- [修改] 删除“环境检测时间阈值”。"
    sed -i '/detect_environment_temp_threshold>[0-9]*</d' "$1" && \
      ui_print "- [修改] 删除“环境检测温度阈值”。"
    sed -i '/more_heat_threshold>/s/>[0-9]*</>600</g' "$1" && \
      ui_print "- [修改] more_heat_threshold标签值：600。"
    sed -i '/<heat_threshold>/s/>[0-9]*</>580</g' "$1" && \
      ui_print "- [修改] heat_threshold标签值：580。"
    sed -i '/less_heat_threshold>/s/>[0-9]*</>560</g' "$1" && \
      ui_print "- [修改] less_heat_threshold标签值：560。"
    sed -i '/preheat_threshold>/s/>[0-9]*</>540</g' "$1" && \
      ui_print "- [修改] preheat_threshold标签值：540。"
    sed -i '/preheat_dex_oat_threshold>/s/>[0-9]*</>520</g' "$1" && \
      ui_print "- [修改] preheat_dex_oat_threshold标签值：520。"
  }
  file_mod_template "$OPLUS_THERMAL_CONFIG" "oplus_thermal_config_mod"
}

oplus_thermal_control_config() {
  # 系统高温控制配置  去除ColorOS（realme 非GT模式）游戏锁帧率等限制
  OPLUS_THERMAL_CONTROL_CONFIG=$OPLUS_TEMPERATURE_PROFILE_DIR/sys_thermal_control_config.xml
  oplus_thermal_control_config_mod(){
    sed -i -e '/specificScene/p' \
      -e '/com\.tencent\.mobileqq_\(scene_\)*103/,/com.tencent.mobileqq_\(scene_\)*103/p' \
      -e '/specificScene/,/\/specificScene/d' \
      "$1" && ui_print "- [修改] specificScene段仅保留腾讯QQ、微信、WhatsApp。"
    sed -i -e '/specific>/p' \
      -e '/com\.oplus\.camera>/,/com\.oplus\.camera>/p' \
      -e '/specific>/,/\/specific>*/d' \
      "$1" && ui_print "- [修改] specific段仅保留 Oplus相机。"
    sed -i 's/fps="[0-9]*/fps="0/g' "$1" && ui_print "- [修改] 禁用温控锁帧率。"
    sed -i 's/cpu="-*[0-9]*/cpu="-1/g' "$1" && ui_print "- [修改] cpu=-1."
    sed -i 's/gpu="-*[0-9]*/gpu="-1/g' "$1" && ui_print "- [修改] gpu=-1."
    sed -i 's/cameraBrightness="[0-9]*/cameraBrightness="255/g' \
      "$1" && ui_print "- [修改] 相机亮度：255。"
    sed -i -e 's/restrict="[0-9]*/restrict="0/g' \
      -e 's/brightness="[0-9]*/brightness="0/g' \
      -e 's/charge="[0-9]*/charge="0/g' \
      -e 's/modem="[0-9]*/modem="0/g' \
      -e 's/disFlashlight="[0-9]*/disFlashlight="0/g' \
      -e 's/stopCameraVideo="[0-9]*/stopCameraVideo="0/g' \
      -e 's/disCamera="[0-9]*/disCamera="0/g' \
      -e 's/disWifiHotSpot="[0-9]*/disWifiHotSpot="0/g' \
      -e 's/disTorch="[0-9]*/disTorch="0/g' \
      -e 's/disFrameInsert="[0-9]*/disFrameInsert="0/g' \
      -e 's/refreshRate="[0-9]*/refreshRate="0/g' \
      -e 's/disVideoSR="[0-9]*/disVideoSR="0/g' \
      -e 's/disOSIE="[0-9]*/disOSIE="0/g' \
      -e 's/disHBMHB="[0-9]*/disHBMHB="0/g' \
      "$1" && \
      ui_print "- [修改] 禁用部分限制：亮度、充电、调制解调器、禁用手电、停止录像、禁用拍照"
      ui_print "禁用热点、禁用Torch、禁用插帧、刷新率、禁用视频SR、禁用超感画质引擎、disHBMHB。"
  }
  file_mod_template "$OPLUS_THERMAL_CONTROL_CONFIG" "oplus_thermal_control_config_mod"

  ui_print "****** realme GT Mode ******"
  # 去除 realme GT模式游戏锁帧率，修改同上。
  OPLUS_THERMAL_CONTROL_CONFIG_GT=$OPLUS_TEMPERATURE_PROFILE_DIR/sys_thermal_control_config_gt.xml
  file_mod_template "$OPLUS_THERMAL_CONTROL_CONFIG_GT" "oplus_thermal_control_config_mod"
}
#### /my_product partition files above ####


#### /odm partition files below ####
oplus_charge_thermal() {
  OPLUS_CHARGE_THERMAL="/odm/firmware/fastchg/${PROJECT_NAME}/charging_thermal_config_default.txt"
  print_title "Oplus charging thermal config"
  if [ "$KSU" = "true" ]; then
    mark_remove_print "$OPLUS_CHARGE_THERMAL"
  else
    #mktouch_replace "${OPLUS_CHARGE_THERMAL%/*}"
    ui_print "- Nothing suitable to do in Magisk environment."
  fi
  ui_print ""
}
#### /odm partition files above ####


#### /my_stock partition files below ####
# Carlink feature 车联特性文件
# OPLUS_CARLINK=/my_stock/etc/extension/feature_carlink.xml
#### /my_stock partition files above ####


#### MOD_ROOT/system directory files below ####
oplus_horae_remove() {
  OPLUS_HORAE=/system_ext/etc/horae/horae_${SOC_MODEL}.conf
  print_title "Oplus horae config"
  if [ "$KSU" = "true" ]; then
    [ -f "$OPLUS_HORAE" ] && mark_remove_print "$OPLUS_HORAE"
  else
    mktouch_replace "/system_ext/etc/horae"
  fi
  ui_print ""
}

oplus_obrain() {
  if [ "$KSU" = "true" ]; then
    print_title "Oplus obrain sql"
    mark_remove_print /system_ext/etc/obrain/assets/selfTest/SqlProxy_Thermal_SelfTestCmd.sql
    mark_remove_print /system_ext/etc/obrain/assets/ThermalAgent_AggThermalAgentAnalyseCmd.sql
    mark_remove_print /system_ext/etc/obrain/assets/ThermalAgent_AggThermalAgentAppHourLyCmd.sql
    mark_remove_print /system_ext/etc/obrain/assets/ThermalAgent_AggThermalAgentDailyCmd.sql
    mark_remove_print /system_ext/etc/obrain/assets/ThermalAgent_CompThermalAgentEventCmd.sql
    ui_print ""
  fi
}

# The config path of App cloner (应用分身)
oplus_multi_app() {
  OPLUS_MULTI_APP=$(find /system_ext/oppo/ /system_ext/oplus/ -type f -iname "sys_multi_app_config.xml" 2>/dev/null)
  oplus_multi_app_mod(){
    sed -i 's/maxNum name="[0-9]*/maxNum name="2000/' "$1" && \
      ui_print "- [修改] 分身应用数量限制：2000。"  # 2000 for 21th century.
    for APKN in $(package_list_3); do
      multiAPKN="<item name=\"$APKN\" \/>"
      sed -i -e "/$multiAPKN/d" -e '/<allowed>/a\        '"$multiAPKN" "$1" && \
        ui_print "- [修改] 去重添加包名 $APKN 到 $1 。"
    done
  }
  file_mod_template "$OPLUS_MULTI_APP" "oplus_multi_app_mod"
}

# Doze whitelist 添加电池优化白名单
oplus_deviceidle_whitelist() {
  OPLUS_DEVICEIDLE_WHITELIST=/system_ext/oplus/sys_deviceidle_whitelist.xml
  oplus_deviceidle_whitelist_mod(){
    for item in $(package_list_3); do
      dumpsys deviceidle whitelist +${item} >&2 2>/dev/null
      cmd appops set $item RUN_IN_BACKGROUND allow
      cmd appops set $item RUN_ANY_IN_BACKGROUND allow
      # grep make a waste of time. Unbearable waiting during module installation.
      #if ! grep -q -w "$item" "$1"; then
      sed -i "/>$item</d" "$1"
        sed -i '/<\/filter-conf>/i\    <wl>'"$item"'<\/wl>' "$1"
        ui_print "- [修改] 添加APP包名 $item 到 $1 。"
      #fi
    done
  }
  file_mod_template "$OPLUS_DEVICEIDLE_WHITELIST" "oplus_deviceidle_whitelist_mod"
  #battery_background
}

oplus_oiface() {
  OPLUS_OIFACE=/system_ext/etc/oiface/oiface.config
  oplus_oiface_mod(){
    ui_print "- [修改] 精简配置文件。来源：酷安@望月古川。"
    echo '{
    "default": {
        "oiface": {
            "enable": 48959
        }
    }
}' > "$1"
}
  # realmeGT2ProCN:21631; OnePlus11CN:22811
  if [ "$PROJECT_NAME" = "21631" ] || [ "$PROJECT_NAME" = "22811" ]; then
    print_title "Oplus oiface config"
    file_mod_template $OPLUS_OIFACE "oplus_oiface_mod"
    ui_print ""
  fi
}

# 温控锁帧
oplus_thermal_level_to_fps() {
  if [ "$KSU" = "true" ]; then
    print_title "Oplus thermal level_to fps"
    mark_remove_print /vendor/etc/display/thermallevel_to_fps.xml
    ui_print ""
  fi
}
#### MOD_ROOT/system directory files above ####


#### /data partition files below ####
# 浮窗 Floating window
oplus_float_window() {
  OPLUS_FLOAT_WINDOW_CONFIG=/data/oplus/zoom/sys_zoom_window_config.xml
  [ -f $OPLUS_FLOAT_WINDOW_CONFIG ] || OPLUS_FLOAT_WINDOW_CONFIG=/system_ext/oplus/sys_zoom_window_config.xml
  oplus_float_window_sed(){
    sed -i '/<filter-conf/,/filter-conf>/c <filter-conf />' \
      "$1" && ui_print "- [修改] 清空XML，目的：所有APP都能小窗。"
  }
  file_mod_template $OPLUS_FLOAT_WINDOW_CONFIG "oplus_float_window_sed"
}

oplus_autostart_white_list() {
  if [ "$API" -lt 33 ]; then
    # cos11~12 自启动白名单，即系统推荐自启动的App包名列表。不在bootwhitelist.txt中的App占用不推荐自启的名额;
    # Android 13 变为允许自启动而非推荐
    OPLUS_AUTOSTART_WHITE_LIST=$($OPLUS_FTF "bootwhitelist.txt" 2>/dev/null)
  elif [ "$API" -eq "33" ]; then
    # cos13 推荐自启
    OPLUS_AUTOSTART_WHITE_LIST=$($OPLUS_FTF "autostart_white_list.txt" 2>/dev/null)
  fi
  oplus_autostart_white_list_mod(){
    for APKN in $(package_list_3); do
      sed -i -e "/^$APKN\$/d" -e '1i'"$APKN" "$1" && \
        ui_print "- [修改] 去重添加包名 $APKN 到 $1 。"
    done
  }
  file_mod_template $OPLUS_AUTOSTART_WHITE_LIST "oplus_autostart_white_list_mod"
}

# Oplus launcher 最近任务管理可锁定数量
oplus_launcher() {
  # cos12~13 欧加桌面(Oplus launcher) 配置
  OPLUS_LAUNCHER_CONFIG=/data/user_de/0/com.android.launcher/shared_prefs/Configuration.xml
  # cos11 OPPO Launcher
  [ -f $OPLUS_LAUNCHER_CONFIG ] || OPLUS_LAUNCHER_CONFIG=/data/user_de/0/com.oppo.launcher/shared_prefs/Configuration.xml
  oplus_launcher_config(){
    sed -i '/lock_app_limit/s/value="[0-9]*/value="2000/' \
      "$1" && \
      ui_print "- [修改] “锁定后台数量限制”值：2000。"
  }
  file_mod_template "$OPLUS_LAUNCHER_CONFIG" "oplus_launcher_config"
}

oplus_secure_pay_app() {
  # 安全支付的启用应用名单  禁用ROOT后打开支付软件时的报毒，需要禁用支付安全环境扫描，可以在系统设置里面手动关闭
  OPLUS_SECUREPAY_ENABLEDAPP=/data/data/com.coloros.securepay/files/enabledapp.xml
  oplus_secure_pay_app_mod(){
    sed -i 's|\(protectapp\).*protectapp>|\1 />|g' "$1" && ui_print "- [修改] 清空<protectapp />标签。"
  }
  file_mod_template "$OPLUS_SECUREPAY_ENABLEDAPP" "oplus_secure_pay_app_mod"
}

# 移除温控配置
oplus_move_battery_throttle() {
  OPLUS_BATTERY_THROTTLE_CONFIG=/data/oplus/os/battery/guardelf_config.xml
  oplus_battery_throttle_config(){
    echo "<?xml version='1.0' encoding='UTF-8' standalone='yes' ?><guardelf_config.xml />" \
      > "$1" && \
      ui_print "- [修改] 移除电池温控配置。"
  }
  file_mod_template "$OPLUS_BATTERY_THROTTLE_CONFIG" "oplus_battery_throttle_config"
}
#### /data partition files above ####


# LTPO enhancement. Idea from int萌新很新@coolapk.
oplus_ltpo() {
  print_title "Oplus refresh rate config"
  oplus_refresh_rate_config
  ui_print ""
  #print_title "Oplus dynamic refresh rate"
  #oplus_adfr_config
  #ui_print "
}

# Some thermal throttle files read by 'com.oplus.thermalcontrol'.
oplus_thermal() {
  case $1 in
    remove)
      print_title "Oplus thermal config REMOVE"
      if [ "$KSU" = "true" ]; then
        if [ "$2" = "specific" ]; then
          mark_remove_print "$OPLUS_HIGH_TEMP_PROTECT" "$OPLUS_THERMAL_CONFIG" "$OPLUS_THERMAL_CONTROL_CONFIG"
          ui_print ""
          return 0
        fi
        mark_replace_print "$OPLUS_TEMPERATURE_PROFILE_DIR" "$OPLUS_ThermalServiceConfig"
        ui_print ""
        return 0
      fi
      ui_print "- Magisk replace method."
      mktouch_replace "$OPLUS_TEMPERATURE_PROFILE_DIR" "$OPLUS_ThermalServiceConfig"
      ui_print ""
      ;;
    mod)
      print_title "Oplus high temp protect"
      oplus_high_temp_protect
      ui_print ""
      print_title "Oplus thermal config"
      oplus_thermal_config
      ui_print ""
      print_title "Oplus thermal control config"
      oplus_thermal_control_config
      ui_print ""
      ;;
  esac
}

main_oplus() {
  print_title "Oplus bootanimation"
  oplus_bootanimation
  ui_print ""
  print_title "Oplus multimedia display perf"
  oplus_display_perf_list
  ui_print ""
  print_title "Oplus system UI feature"
  oplus_sysui_cos13
  ui_print ""
  print_title "Oplus system UI extend feature"
  oplus_extend_feature_rui3_4
  ui_print ""
  if [ "$PROJECT_NAME" = "22811" ]; then
    # OnePlus 11 Chinese Edition
    print_title "Oplus APP features"
    oplus_app_features
    ui_print ""
  fi
  oplus_ltpo
  print_title "Oplus APN"
  oplus_apns_conf
  ui_print ""
  oplus_thermal remove

  oplus_charge_thermal

  oplus_horae_remove
  oplus_obrain
  print_title "Oplus multi applications"
  oplus_multi_app
  ui_print ""
  print_title "Oplus device idle(battery optimization) whitelist"
  oplus_deviceidle_whitelist
  ui_print ""
  oplus_oiface
  oplus_thermal_level_to_fps

  print_title "Oplus floating window"
  oplus_float_window
  ui_print ""
  print_title "Oplus autostart white list"
  oplus_autostart_white_list
  ui_print ""
  print_title "Oplus launcher config"
  oplus_launcher
  ui_print ""
  print_title "Oplus securepay applications"
  oplus_secure_pay_app
  ui_print ""
  print_title "Oplus battery throttle config"
  oplus_move_battery_throttle
  ui_print ""

  # 冻结负优化
  pm disable --user 0 com.oplus.cosa/com.oplus.cosa.gpalibrary.service.GPAService >/dev/null
  ui_print "- 已冻结 com.oplus.cosa/com.oplus.cosa.gpalibrary.service.GPAService ，卸载模块时可能需手动启用解冻！！"
}

[ -z "$MOD_ROOT" ] && . "${0%/*}/check-env.sh"

#main_oplus
